% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumpTests.R
\name{BNSjumpTest}
\alias{BNSjumpTest}
\title{Barndorff-Nielsen and Shephard (2006) tests for the presence of jumps in the price series.}
\usage{
BNSjumpTest(
  rData,
  IVestimator = "BV",
  IQestimator = "TP",
  type = "linear",
  logTransform = FALSE,
  max = FALSE,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE,
  alpha = 0.975
)
}
\arguments{
\item{rData}{either an \code{xts} or a \code{data.table} containing the log-returns or prices of a single asset, possibly over multiple days-}

\item{IVestimator}{can be chosen among jump robust integrated variance estimators: 
\code{\link{rBPCov}}, \code{\link{rMinRV}}, \code{\link{rMedRV}} and corrected threshold bipower variation (\code{\link{rThresholdCov}}). 
If \code{\link{rThresholdCov}} is chosen, an argument of \code{startV}, start point of auxiliary estimators in threshold estimation can be included. \code{\link{rBPCov}} by default.}

\item{IQestimator}{can be chosen among jump robust integrated quarticity estimators: \code{\link{rTPQuar}}, \code{\link{rQPVar}}, \code{\link{rMinRQ}} and \code{\link{rMedRQ}}. 
\code{\link{rTPQuar}} by default.}

\item{type}{a method of BNS testing: can be linear or ratio. Linear by default.}

\item{logTransform}{boolean, should be \code{TRUE} when \code{QVestimator} and \code{IVestimator} are in logarithm form. \code{FALSE} by default.}

\item{max}{boolean, should be \code{TRUE} when max adjustment in SE. \code{FALSE} by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}.
To aggregate based on a 5 minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5 minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{pData} contains prices. \code{FALSE} by default.}

\item{alpha}{numeric of length one with the significance level to use for the jump test(s). Defaults to 0.975.}
}
\value{
a list or \code{xts} (depending on whether input prices span more than one day)
with the following values:
\itemize{
\item \eqn{z}-test value.
\item critical value (with confidence level of 95\%).
\item \eqn{p}-value of the test. 
}
}
\description{
This test examines the presence of jumps in highfrequency price series. It is based on theory of Barndorff-Nielsen and Shephard (2006). 
The null hypothesis is that there are no jumps.
}
\details{
Assume there is \eqn{N} equispaced returns in period \eqn{t}. 
Assume the Realized variance (RV), IVestimator and IQestimator are based on \eqn{N} equi-spaced returns. 

Let \eqn{r_{t,i}} be a return (with \eqn{i = 1, \ldots, N}) in period \eqn{t}. 

Then the BNSjumpTest is given by
\deqn{
\mbox{BNSjumpTest}= \frac{\code{RV} - \code{IVestimator}}{\sqrt{(\theta-2)\frac{1}{N} {\code{IQestimator}}}}.
}
The options for \code{IVestimator} and \code{IQestimator} are listed above. \eqn{\theta} depends on the chosen \code{IVestimator} (Huang and Tauchen, 2005).

The theoretical framework underlying the jump test is that the logarithmic price process \eqn{X_t} belongs to the class of Brownian semimartingales, which can be written as:
\deqn{
\mbox{X}_{t}=  \int_{0}^{t} a_u \ du + \int_{0}^{t}\sigma_{u} \ dW_{u} + Z_t
}
where \eqn{a} is the drift term, \eqn{\sigma} denotes the spot volatility process, \eqn{W} is a standard Brownian motion and \eqn{Z} is a jump process defined by:
\deqn{
\mbox{Z}_{t}=  \sum_{j=1}^{N_t}k_j
}
where \eqn{k_j} are nonzero random variables. The counting process can be either finite or infinite for finite or infinite activity jumps.

Since the realized volatility converges to the sum of integrated variance and jump variation, while the robust \code{IVestimator} converges to the integrated variance, 
it follows that the difference between \code{RV} and the \code{IVestimator} captures the jump part only, and this observation underlines the BNS test for jumps (Theodosiou and Zikes, 2009).
}
\examples{
bns <- BNSjumpTest(sampleTData[, list(DT, PRICE)], IVestimator= "rMinRV",
                   IQestimator = "rMedRQ", type= "linear", makeReturns = TRUE)
bns

}
\references{
Barndorff-Nielsen, O. E., and Shephard, N. (2006). Econometrics of testing for jumps in financial economics using bipower variation. \emph{Journal of Financial Econometrics}, 4, 1-30. 

Corsi, F., Pirino, D., and Reno, R. (2010). Threshold bipower variation and the impact of jumps on volatility forecasting. \emph{Journal of Econometrics}, 159, 276-288.

Huang, X., and Tauchen, G. (2005). The relative contribution of jumps to total price variance. \emph{Journal of Financial Econometrics}, 3, 456-499.

Theodosiou, M., and Zikes, F. (2009). A comprehensive comparison of alternative tests for jumps in asset prices. Unpublished manuscript, Graduate School of Business, Imperial College London.
}
\author{
Giang Nguyen, Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{BNSjumpTest}
\keyword{highfrequency}
