\name{MCMC}
\alias{MCMC}
\title{
MCMC routine for fitting HKEVP.
}
\description{
C++ function called by \code{hkevp.fit}. Should not be used directly by the user!
}
\usage{
MCMC(Y, sites, spatial_covariates, knots, dsk, dss, niter, nburn, nthin, trace, gev_vary,
gev_init, alpha_init, tau_init, A_init, B_init, sills_init, ranges_init,
constant_gev_prior, alpha_prior, tau_prior, beta_variance_prior, sill_prior, range_prior,
gev_random_walk, range_random_walk, tau_random_walk, alpha_random_walk,
A_random_walk, B_random_walk, quiet, latent_processes_correlation_type, nas)
}
\arguments{
  \item{Y}{Observed process.}
  \item{sites}{Spatial positions where Y is observed.}
  \item{spatial_covariates}{Spatial covariates for GEV parameters.}
  \item{knots}{Spatial positions of the knots.}
  \item{dsk}{Distance matrix between sites and knots.}
  \item{dss}{Distance matrix between sites.}
  \item{niter}{Number of iterations before the algorithm stops.}
  \item{nburn}{Number of first iterations to burn.}
  \item{nthin}{Size of thinning.}
  \item{trace}{Size of tracing display.}
  \item{gev_vary}{Are the GEV parameters spatially varying?}
  \item{gev_init}{Initial state for GEV parameters.}
  \item{alpha_init}{Initial state for alpha parameter.}
  \item{tau_init}{Initial state for tau parameter.}
  \item{A_init}{Initial state for random effect A.}
  \item{B_init}{Initial state for random effect B.}
  \item{sills_init}{Initial state for sills hyperparameters.}
  \item{ranges_init}{Initial state for ranges hyperparameters.}
  \item{constant_gev_prior}{Prior hyperparameters for spatially-constant GEV parameters.}
  \item{alpha_prior}{Prior hyperparameters for alpha.}
  \item{tau_prior}{Prior hyperparameters for tau.}
  \item{beta_variance_prior}{Prior hyperparameter for variance of Beta's.}
  \item{sill_prior}{Prior hyperparameters for sills.}
  \item{range_prior}{Prior hyperparameters for ranges.}
  \item{gev_random_walk}{Random walk standard deviation for GEV parameters.}
  \item{range_random_walk}{Random walk standard deviation for ranges.}
  \item{tau_random_walk}{Random walk standard deviation for tau.}
  \item{alpha_random_walk}{Random walk standard deviation for alpha.}
  \item{A_random_walk}{Random walk standard deviation for A.}
  \item{B_random_walk}{Random walk standard deviation for B.}
  \item{quiet}{Display or not the MCMC progression.}
  \item{latent_processes_correlation_type}{Type of spatial correlation (latent processes).}
  \item{nas}{Matrix indicating missing values}
}
\details{
This function is automatically generated by \code{Rcpp} package: user should not use it directly as it is not protected (risk of segmentation fault). See \code{hkevp.fit} instead.
}
%\value{}
%\references{}
\author{Quentin Sebille}
%\note{}

\seealso{
\code{\link{hkevp.fit}}
}
%\examples{}
