% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.plot.R
\name{mcmc.plot}
\alias{mcmc.plot}
\title{Markov chains plotting}
\usage{
mcmc.plot(fit, plot.spatial, mfrow)
}
\arguments{
\item{fit}{Output from the \code{hkevp.fit} procedure.}

\item{plot.spatial}{Logical indicating if the Markov chains of the sills and ranges hyperparameters should be plotted. FALSE by default.}

\item{mfrow}{Optional vector of two numerical values indicating the parameter of the window plotting called by the \code{plot(...)} function.}
}
\description{
Plots of the resulting Markov chains obtained by the MCMC procedures \code{hkevp.fit} or \code{latent.fit}. May be used to assess graphically convergence of the chains.
}
\examples{
# Simulation of HKEVP:
sites <- as.matrix(expand.grid(1:3,1:3))
knots <- sites
loc <- sites[,1]*10
scale <- 3
shape <- .2
alpha <- .4
tau <- 1
ysim <- hkevp.rand(10, sites, knots, loc, scale, shape, alpha, tau)

# HKEVP fit:
fit <- hkevp.fit(ysim, sites, niter = 1000)

# Markov chains plot:
# mcmc.plot(fit)




}
\author{
Quentin Sebille
}

