% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sets.R
\name{get.term.pseudo.adjacency.matrix}
\alias{get.term.pseudo.adjacency.matrix}
\title{Get an adjacency to MRCA matrix for set of HPO terms}
\usage{
get.term.pseudo.adjacency.matrix(hpo.terms, terms)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}
}
\value{
A logical matrix represenging the directed adjacency matrix of \code{terms} based on DAG structure of HPO, whereby a TRUE entry signifies the term correspnding to the column is MRCA of the row term in \code{terms}
}
\description{
Get an adjacency to MRCA matrix for set of HPO terms
}
\examples{
data(hpo.terms)
get.term.pseudo.adjacency.matrix(hpo.terms, c("HP:0000118", "HP:0001873", "HP:0011877"))
}
\seealso{
\code{\link{get.term.adjacency.matrix}}
}

