% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hep_bioavailability.R
\name{calc_hep_bioavailability}
\alias{calc_hep_bioavailability}
\title{Calculate first pass metabolism}
\usage{
calc_hep_bioavailability(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  restrictive.clearance = T,
  flow.34 = T
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{http://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model}

\item{restrictive.clearance}{Protein binding not taken into account (set to 1) in 
liver clearance if FALSE.}

\item{flow.34}{A logical constraint}
}
\value{
A data.table whose columns are the parameters of the HTTK model
 specified in \code{model}.
}
\description{
For models that don't described first pass blood flow from the gut, need to
cacluate a hepatic bioavailability, that is, the fraction of chemical 
systemically available after metabolism during the first pass through the 
liver (Rowland, 1973).
}
\references{
Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. 
"Clearance concepts in pharmacokinetics." Journal of pharmacokinetics and 
biopharmaceutics 1.2 (1973): 123-136.
}
\author{
John Wambaugh
}
\keyword{physiology}
