% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{httk_chem_subset}
\alias{httk_chem_subset}
\title{HTTK data chemical subsetting function}
\usage{
httk_chem_subset(data, chem_include)
}
\arguments{
\item{data}{Data frame, with chemical data, to be subset.}

\item{chem_include}{(\emph{character vector}) A character vector containing
CAS/CASRN or DTXSID chemical identifiers to include in the data subset.}
}
\value{
A subset data set containing only the data rows for chemicals identified
as those that should be included.
}
\description{
This function is meant to take any `httk` data and subset it based on a list
of chemicals provided. Main functionality is for speeding up the `load_sipes2017`,
`load_pradeep2020`, `load_dawson2021`, `load_honda2023`, and similar phys-chem
data files.  However, it should be generalizable to any dataset with CAS/CASRN
or DTXSID chemical identifiers.
}
