% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{select.autosomes}
\alias{select.autosomes}
\title{Select ranges only within the 22 autosomes in a ranged data object}
\usage{
select.autosomes(ranges, deselect = FALSE)
}
\arguments{
\item{ranges}{A RangedData or GRanges object}

\item{deselect}{logical, if TRUE, then will select non-autosomes}
}
\value{
an object of the same format as the input (ranges), except
with non-autosomal ranges removed.
}
\description{
Select only data from autosomes from a GRanges/RangedData object.
Will exclude X,Y, mitochondrial chromosome rows, and can automatically
detect whether chromosomes are coded as 'chr1' or just '1', etc.
}
\examples{
rand.ranges <- rranges(chr.range=20:26)
rand.ranges # should include some non-autosomes
select.autosomes(rand.ranges) # only autosomes remain
}

