% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{AB}
\alias{AB}
\title{Returns the A and B allele for SNP ids}
\usage{
AB(ids)
}
\arguments{
\item{ids}{character, a list of chip ids or rs-ids as contained in the current ChipInfo object}
}
\value{
Returns a two column matrix containing the A and B allele.
}
\description{
For a set of chip ids or rs ids, returns a two column matrix containing the A and B allele. 
For snpStats objects the default is that A,B are coded in alphabetical order, so A,C; A,T; 
C,T; C,G are possible A,B pairs. Allele codes are specific to each dataset, so you should
upload your allele codes into the current ChipInfo object to make the alleles produced by
this function meaningful.
}
\examples{
\donttest{
snp.ids <- c("rs3842724","rs9729550","rs1815606","rs114582555","rs1240708","rs6603785")
AB(snp.ids) 
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.band}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}

