% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{df.to.GRanges}
\alias{df.to.GRanges}
\title{Convert a data.frame with positional information to GRanges}
\usage{
df.to.GRanges(dat, ...)
}
\arguments{
\item{dat}{a data.frame with chromosome and position information}

\item{...}{additional arguments to df.to.ranged(), namely:
ids, start, end, width, chr, exclude and build}
}
\value{
A RangedData or GRanges object. If 'dat' doesn't
use the default column names, specify these using parameters
ids, start, and end or width. Exclude will remove prevent any 
column names of 'dat' specified not to be translated to the 
returned GRanges object. 'build' specifies the 'genome'
slot of the resulting object. 'ids' allows specification of
a column to be converted to the rownames of the new object.
}
\description{
Convert a data.frame containing chromosome and position information
to a GRanges object. Assumes the position information is contained in
columns named 'chr', 'start' and 'end' respectively (not case sensitive) 
although you can enter alternative column names for each as parameters. 
'seqnames' will be automatically detected as an alternative to 'chr' if 
present. Column names that are default GRanges slot names such as 'seqnames',
'ranges', 'strand', 'seqlevels', etc, will be removed during conversion, so
rename these if you want them to be translated into the resulting GRanges
objects' column metadata. If there is a column 'pos' but no columns 'start'
 and 'end' this will be detected automatically without needing to change
 the default parameters and start will equal end equals pos (ie., SNPs).
}
\examples{
chr <- sample(1:22,10)
start <- end <- sample(1000000,10)
df1 <- cbind(chr,start,end)
df.to.GRanges(df1) # basic conversion
width <- rep(0,10)
df2 <- cbind(chr,start,width)
df.to.GRanges(df2,end=NULL,width="width") # define ranges with start and width
id.col <- paste0("ID",1:10)
rs.id <- paste0("rs",sample(10000,10))
df3 <- cbind(chr,start,end,id.col,rs.id)
df.to.GRanges(df3) # additional columns kept
df4 <- cbind(chr,start,end,id.col,rs.id, ranges=1:10)
df.to.GRanges(df4) # 'ranges' column excluded as illegal name
df.to.GRanges(df4, exclude="rs.id") # manually exclude column
df5 <- cbind(chr,start,end,rs.id)
rownames(df5) <- paste0("ID",1:10)
df.to.GRanges(df5) # rownames are kept
df.to.GRanges(df4,ids="id.col") # use column of 'dat' for rownames
}
\seealso{
\code{\link{ranged.to.data.frame}}, \code{\link{df.to.ranged}}
}

