% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{snps.in.range}
\alias{snps.in.range}
\title{Retrieve SNP ids or positions in specified range}
\usage{
snps.in.range(chr, start = NA, end = start, ids = TRUE)
}
\arguments{
\item{chr}{integer, chromosome, should be a number from 1 to 25, where 23,24,25 are X,Y,MT
Alternatively chr can be a RangedData or GRanges object in which case SNP lists will be returned
in a list for each row of the ranges object.}

\item{start}{integer, genomic position to define the start of the range to look for SNPs,
should be between 1 and the length of the chromosome 'chr'}

\item{end}{integer, genomic position to define the end of the range to look for SNPs,
should be between 1 and the length of the chromosome 'chr', and >= start}

\item{ids}{logical, if TRUE will return snp ids (chip ids, for rs-ids, use id.to.rs on the output), 
or if FALSE will return the chromosome positions of the SNPs.}
}
\value{
Set of SNP ids (when ids=TRUE), or otherwise genomic positions within chromosome 'chr', that
fall within the genomic range described by the chr, start, and end parameters. Alternatively, if
chr is a RangedData or GRanges object then multiple SNP lists will be returned
in a list for each row of the ranges object.
}
\description{
This function will always use the build in getOption('ucsc'), so use options() if it needs to 
change.
}
\examples{
snps.in.range(1,9000000,10000000)
snps.in.range(10,19000000,20000000,ids=TRUE)
snps.in.range(10,19000000,20000000,ids=FALSE) # return positions instead of rs-ids
}
