%% File calendarHeatmap.Rd
%% Part of the hydroTSM R package, https://github.com/hzambran/hydroTSM ; 
%%                                 https://CRAN.R-project.org/package=hydroTSM
%%                                 https://www.rforge.net/hydroRTS/ ; 
%% Copyright 2008-2022 Mauricio Zambrano-Bigiarini
%% Distributed under GPL 2 or later

\name{calendarHeatmap}
\Rdversion{1.1}
\alias{calendarHeatmap}
\alias{calendarHeatmap.zoo}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calendar heatmap
}
\description{
Function to plot a heatmap of a daily zoo object with a calendar shape
}
\usage{
calendarHeatmap(x, ...)

\method{calendarHeatmap}{zoo}(x, from, to, date.fmt="\%Y-\%m-\%d",
                main="Calendar Heat Map",
                col=colorRampPalette(c("red", "orange", "yellow", "white", 
                    "lightblue2", "deepskyblue", "blue3"),  space = "Lab")(8),  
                cuts, cuts.dec=0, cuts.labels, 
                cuts.style=c("fisher", "equal", "pretty", "fixed", "sd", 
                             "quantile", "kmeans", "bclust", "mzb"), 
                legend.title="", legend.fontsize=15,              
                do.png=FALSE, png.fname="mypng.png", png.width=1500, 
                png.height=900, png.pointsize=12, png.res=90,
                do.pdf=FALSE, pdf.fname="mypdf.pdf", pdf.width=11,
                pdf.height=8.5, pdf.pointsize=12, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
daily zoo object to be plotted. Its maximum amount of daily data should be less than 6 years or otherwise it will not be plotted.
}
  \item{from}{
Character indicating the starting date for subsetting \code{x}. It has to be in the format indicated by \code{date.fmt}. 
}
  \item{to}{
Character indicating the ending date for subsetting \code{x}. It has to be in the format indicated by \code{date.fmt}. 
}
  \item{date.fmt}{
character indicating the format in which the dates are stored in \code{from} and \code{to}, e.g. \kbd{\%Y-\%m-\%d}. See \sQuote{Details} section in \code{\link[base]{strptime}}.
}
\item{main}{
character, Main chart title.
}
\item{col}{
A color palette, i.e. a vector of n contiguous colors generated by functions like rainbow, heat.colors, topo.colors, bpy.colors or one of your own making, perhaps using \code{\link[grDevices]{colorRampPalette}}. If none is provided, a color ramp with 8 colours is created using \code{\link[grDevices]{colorRampPalette}}. 
}
\item{cuts}{
Numeric, indicating the values used to divide the range of \code{x} in the legend of colours. If not provided, it is automatically selected as a function of \code{lenght(col)}.
}
\item{cuts.dec}{
Number of decimal places used to present the numbers in the legend of colours.
}
\item{cuts.labels}{
Character indicating the label to be used in the colour legend for each one of the values defined by \code{cuts}. If not provided, \code{as.character(cuts)} is used.
}
\item{cuts.style}{
discarded because takes too much time or not alway provide the required number of classes: "dpih", "headtails", "hclust",  "jenks".
}
\item{legend.title}{
text to be displayed above the legend of colours.
}
\item{legend.fontsize}{
size of text (in points) used in the legend of colours.
}
\item{do.png}{
Do you want to write the figure as a .png file? logical, set TRUE to save the image.
}
\item{png.fname}{
character, indicating the name of the file (possibly with a meaninful file extension) that will be used to write the output file.
}
\item{png.width}{
numeric, the width of the device.
}
\item{png.height}{
numeric, the height of the device.
}
\item{png.pointsize}{
integer, the default pointsize of plotted text, interpreted as big points (1/72 inch) at \code{res} ppi.
}
\item{png.res}{
integer, the nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer. Also used for units other than the default, and to convert points to pixels.
}
\item{do.pdf}{
Do you want to write the figure as a .pdf file? logical, set TRUE to save the image.
}
\item{pdf.fname}{
character, indicating the name of the file (possibly with a significant extension) that will be used to write the output file.
}
\item{pdf.width}{
numeric, the width of the device.
}
\item{pdf.height}{
numeric, the height of the device.
}
\item{pdf.pointsize}{
integer, the default point size to be used. Strictly speaking, in bp, that is 1/72 of an inch, but approximately in points. Defaults to 12.
}
  \item{\dots}{
further arguments passed to functions or from other methods. Not used yet.
}
}
\details{
The original function \code{calendarHeat} was developed by Paul Bleicher, as an R version of a graphic from http://stat-computing.org/dataexpo/2009/posters/wicklin-allison.pdf (not available any longer).
The original function was made available online in 2009, but then it was removed. Now it is available at \url{https://github.com/tavisrudd/r_users_group_1/blob/master/calendarHeat.R}.
The original function has "Copyright 2009 Humedica", but it was distributed under the GPL-2 licence, as well as this new version of the function.

This slighly modified verison of the function is also distributed under the GPL-2 licence, and teh main changes with respect to the original function are: \cr

1) uses a zoo object instead of a numeric and character vector, for values and dates, respectively. \cr
2) it allows a customisation of the mian title of the output figure. \cr
3) it allows a customisation of the color palette. \cr
4) it uses a categorical legend instead of a continuos one. \cr
5) it is named \code{calendarHeatmap} instead of \code{calendarHeat}.


}
\value{
The output of this function is a lattice figure with the calendar heatmap
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Mauricio Zambrano-Bigiarini, \email{mzb.devel@gmail.com}
}
\note{
The maximum amount of years to be plotted is six (6).
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[grDevices]{colorRampPalette}}, \code{\link[lattice]{levelplot}}
}
\examples{
###########
# EXAMPLE 1: basic plotting of a calendar heatmap
###########

# Loading daily streamflow data for Karamet at Gorges.
data(KarameaAtGorgeQts)

x <- KarameaAtGorgeQts
x <- subdaily2daily(x, FUN=mean)

# Temporal subsetting for a amaximum of 6 years
x <- window(x, start="1980-01-01", end="1985-12-31")

# Calendar Heatmap, 8 colours and cuts defined using Fisher method 
calendarHeatmap(x)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{graphs}
%%keyword{manip}
