% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\docType{methods}
\name{bind}
\alias{bind}
\alias{cbind.hyperSpec}
\alias{bind}
\alias{rbind.hyperSpec}
\alias{cbind2,hyperSpec,hyperSpec-method}
\alias{rbind2,hyperSpec,hyperSpec-method}
\alias{cbind2,hyperSpec,missing-method}
\alias{rbind2,hyperSpec,missing-method}
\alias{rbind.hyperSpec}
\alias{cbind2,hyperSpec,hyperSpec-method}
\alias{cbind2,hyperSpec,missing-method}
\alias{rbind2,hyperSpec,hyperSpec-method}
\alias{rbind2,hyperSpec,missing-method}
\title{Binding hyperSpec Objects}
\usage{
bind(direction = stop("direction ('c' or 'r') required"), ...,
  wl.tolerance = hy.getOption("wl.tolerance"))

\method{cbind}{hyperSpec}(...)

\method{rbind}{hyperSpec}(...)

\S4method{cbind2}{hyperSpec,hyperSpec}(x, y)

\S4method{cbind2}{hyperSpec,missing}(x, y)

\S4method{rbind2}{hyperSpec,hyperSpec}(x, y,
  wl.tolerance = hy.getOption("wl.tolerance"))

\S4method{rbind2}{hyperSpec,missing}(x, y, wl.tolerance)
}
\arguments{
\item{direction}{"r" or "c" to bind rows or columns}

\item{...}{The \code{hyperSpec} objects to be combined.

Alternatively, \emph{one} list of \code{hyperSpec} objects can be given to
  \code{bind}.}

\item{wl.tolerance}{\code{rbind} and \code{rbind2} check for equal wavelengths
with this tolerance.}

\item{x, y}{\code{hyperSpec} objects}
}
\value{
a \code{hyperSpec} object, possibly with different row order (for
  \code{bind ("c", \dots{})} and \code{cbind2}).
}
\description{
The former difficulties with binding S4 objects
are resolved since R version 3.2.0 and \code{cbind} and \code{rbind} now work as intended and
expected for hyperSpec objects.

\code{cbind2} binds the spectral matrices of two \code{hyperSpec} objects by column. All columns
besides \code{spc} with the same name in \code{x@data} and \code{y@data} must have the same
elements.  Rows are ordered before checking.

\code{rbind2} binds two \code{hyperSpec} objects by row. They need to have
the same columns.
}
\details{
Therefore, calling \code{rbind.hyperSpec} and
\code{cbind.hyperSpec} is now depecated: \code{cbind} and \code{rbind} should now be called
directly.

However, in consequence it is no longer possible to call \code{cbind} or \code{rbind} with a
list of hyperSpec objects. In that case, use \code{bind} or \code{\link[base]{do.call}} (see example).

\code{bind} does the common work for both column- and row-wise binding.
}
\note{
You might have to make sure that the objects either all have or all
  do not have rownames and/or colnames.
}
\examples{

chondro
bind ("r", chondro, chondro)
rbind (chondro, chondro)
cbind (chondro, chondro)
bind ("r", list (chondro, chondro, chondro))

x <- chondro[,, 600 : 605]
x$a <- 1
x@data <- x@data[, sample (ncol (x), ncol (x))] # reorder columns

y <- chondro [nrow (chondro) : 1,, 1730 : 1750] # reorder rows
y$b <- 2

cbind2 (x, y) # works

y$y[3] <- 5
try (cbind2 (x, y)) # error

# list of hyperSpec objects

lhy <- list (flu, flu)
do.call ("rbind", lhy)
bind ("r", lhy)
}
\seealso{
\code{\link[methods]{rbind2}}, \code{\link[methods]{cbind2}}
\code{\link[base]{rbind}}, \code{\link[base]{cbind}}

\code{\link{merge}} and \code{\link{collapse}} for combining objects that do not share spectra
or wavelengths, respectively.
}
\author{
C. Beleites
}
\keyword{manip}
\keyword{methods}
