% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoSpecies}
\alias{ChaoSpecies}
\title{Estimation of species richness}
\usage{
ChaoSpecies(x, datatype = "abundance", conf = 0.95)
}
\arguments{
\item{x}{a vector of species abundances or incidence frequencies. If \code{datatype = "incidence"},
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or
sampling-unit-based incidence data (\code{datatype = "incidence"}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}
}
\value{
A vector of observed species richness, species richness estimate, s.e. and the associated confidence interval.
}
\description{
\code{ChaoSpecies}: estimation of species richness based on the methods proposed in Chao (1984, 1987).
}
\examples{
data(spider)
ChaoSpecies(spider$Girdled, datatype="abundance")
}
\references{
Chao, A. (1984) Nonparametric estimation of the number of classes in a population. Scandinavian Journal of Statistics, 11, 265-270.\cr\cr
Chao, A. (1987) Estimating the population size for capture-recapture data with unequal catchability. Biometrics, 43, 783-791.
}
\seealso{
\code{\link{ChaoEntropy}, \link{EstSimpson}}
}

