% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_nosort.R
\name{refactor}
\alias{refactor}
\title{Refactor by integer matching levels in C++}
\usage{
refactor(x, levels, na.rm = FALSE, exclude_na = TRUE)
}
\arguments{
\item{exclude_na}{Simpler equivalent to \code{base::factor} exclude. By default,
\code{refactor} will not count \code{NA} as a factor level if there are \code{NA} elements
in the input data.}
}
\description{
Slightly slower for small factors, three times faster for one hundred million
elements with two million new levels. Three times faster for any \code{n > 1e6}.
With \code{NA} values, margin is smaller, but still beats base \code{factor}.
}
\examples{
\dontrun{
  f <- factor(c(1, 2, 3))
  icd:::refactor(f, c("2", "3"))
  f <- factor(c(1, 2, NA))
  icd:::refactor(f, c("2", "3", NA))
}
}
\keyword{internal}
\keyword{manip}
