% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{charlson}
\alias{charlson}
\alias{charlson.data.frame}
\title{Calculate Charlson Comorbidity Index (Charlson Score)}
\usage{
charlson(x, visit_name = NULL, scoring_system = c("original",
  "charlson", "quan"), return_df = FALSE,
  stringsAsFactors = getOption("stringsAsFactors"), ...)

\method{charlson}{data.frame}(x, visit_name = NULL,
  scoring_system = c("original", "charlson", "quan"),
  return_df = FALSE, stringsAsFactors = getOption("stringsAsFactors"),
  ...)
}
\arguments{
\item{x}{data frame containing a column of visit or patient identifiers, and
a column of ICD-9 codes. It may have other columns which will be ignored.
By default, the first column is the patient identifier and is not counted.
If \code{visit_name} is not specified, the first column is used.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{scoring_system}{One of \code{original}, \code{charlson}, or
\code{quan}. The first two will give the original Charlson weights for each
comorbidity, whereas \code{quan} uses the updated weights from Quan 2011.}

\item{return_df}{single logical value, if \code{TRUE}, a two column data
frame will be returned, with the first column named as in input data frame
(i.e., \code{visit_name}), containing all the visits, and the second column
containing the Charlson Comorbidity Index.}

\item{stringsAsFactors}{single logical, passed on when constructing
data.frame if \code{return_df} is \code{TRUE}. If the input data frame
\code{x} has a factor for the \code{visit_name}, this is not changed, but a
non-factor \code{visit_name} may be converted or not converted according to
your system default or this setting.}

\item{...}{further arguments to pass on to \code{icd9_comorbid_quan_deyo},
e.g. \code{name}}
}
\description{
Charlson score is calculated in the basis of the Quan revision
  of Deyo's ICD-9 mapping. (Peptic ulcer disease no longer warrants a point.)
  Quan published an updated set of scores, but it seems most people use the
  original scores for easier comparison between studies, even though Quan's
  were more predictive.
}
\details{
When used, hierarchy is applied per Quan, \dQuote{The following
  comorbid conditions were mutually exclusive: diabetes with chronic
  complications and diabetes without chronic complications; mild liver
  disease and moderate or severe liver disease; and any malignancy and
  metastatic solid tumor.} The Quan scoring weights come from the 2011 paper.
  The comorbidity weights were recalculated using updated discharge data, and
  some changes, such as Myocardial Infarction decreasing from 1 to 0, may
  reflect improved outcomes due to advances in treatment since the original
  weights were determined in 1984.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Charlson scores from data frame of visits and ICD-9
codes. ICD-10 Charlson can be calculated simply by getting the Charlson
(e.g. Quan Deyo) comorbidities, then calling
\code{charlson_from_comorbid}.
}}

\examples{
mydf <- data.frame(
  visit_name = c("a", "b", "c"),
  icd9 = c("441", "412.93", "042")
)
charlson(mydf)
cmb <- icd9_comorbid_quan_deyo(mydf)
cmb
# can specify short_code directly instead of guessing
charlson(mydf, short_code = FALSE, return_df = TRUE)
charlson_from_comorbid(cmb)
}
