% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{igraph-minus}
\alias{igraph-minus}
\alias{-.igraph}
\title{Delete vertices or edges from a graph}
\usage{
\method{-}{igraph}(e1, e2)
}
\arguments{
\item{e1}{Left argument, see details below.}

\item{e2}{Right argument, see details below.}
}
\value{
An igraph graph.
}
\description{
Delete vertices or edges from a graph
}
\details{
The minus operator (\sQuote{\code{-}}) can be used to remove vertices
or edges from the graph. The operation performed is selected based on
the type of the right hand side argument:
\itemize{
\item If it is an igraph graph object, then the difference of the
  two graphs is calculated, see \code{\link{difference}}.
\item If it is a numeric or character vector, then it is interpreted
  as a vector of vertex ids and the specified vertices will be
  deleted from the graph. Example: \preformatted{  g <- make_ring(10)
V(g)$name <- letters[1:10]
g <- g - c("a", "b")}
\item If \code{e2} is a vertex sequence (e.g. created by the
  \code{\link{V}} function), then these vertices will be deleted from
  the graph.
\item If it is an edge sequence (e.g. created by the \code{\link{E}}
  function), then these edges will be deleted from the graph.
\item If it is an object created with the \code{\link{vertex}} (or the
  \code{\link{vertices}}) function, then all arguments of \code{\link{vertices}} are
  concatenated and the result is interpreted as a vector of vertex
  ids. These vertices will be removed from the graph.
\item If it is an object created with the \code{\link{edge}} (or the
  \code{\link{edges}}) function, then all arguments of \code{\link{edges}} are
  concatenated and then interpreted as edges to be removed from the
  graph.
  Example: \preformatted{  g <- make_ring(10)
V(g)$name <- letters[1:10]
E(g)$name <- LETTERS[1:10]
g <- g - edge("e|f")
g <- g - edge("H")}
\item If it is an object created with the \code{\link{path}} function,
  then all \code{\link{path}} arguments are concatenated and then interpreted
  as a path along which edges will be removed from the graph.
  Example: \preformatted{  g <- make_ring(10)
V(g)$name <- letters[1:10]
g <- g - path("a", "b", "c", "d")}
}
}
\seealso{
Other functions for manipulating graph structure: \code{\link{+.igraph}},
  \code{\link{add_edges}}, \code{\link{add_vertices}},
  \code{\link{delete_edges}},
  \code{\link{delete_vertices}}, \code{\link{edge}},
  \code{\link{path}}, \code{\link{vertex}}
}
