% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{keeping_degseq}
\alias{keeping_degseq}
\title{Graph rewiring while preserving the degree distribution}
\usage{
keeping_degseq(loops = FALSE, niter = 100)
}
\arguments{
\item{loops}{Whether to allow destroying and creating loop edges.}

\item{niter}{Number of rewiring trials to perform.}
}
\description{
This function can be used together with \code{\link{rewire}} to
randomly rewire the edges while preserving the original graph's degree
distribution.
}
\details{
The rewiring algorithm chooses two arbitrary edges in each step ((a,b)
and (c,d)) and substitutes them with (a,d) and (c,b), if they not
already exists in the graph. The algorithm does not create multiple
edges.
}
\examples{
g <- make_ring(10)
g \%>\%
  rewire(keeping_degseq(niter = 20)) \%>\%
  degree()
print_all(rewire(g, with = keeping_degseq(niter = vcount(g) * 10)))
}
\seealso{
\code{\link{sample_degseq}}

Other rewiring functions: \code{\link{each_edge}},
  \code{\link{rewire}}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\concept{rewiring functions}
\keyword{graphs}
