% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centr_betw_tmax}
\alias{centr_betw_tmax}
\alias{centralization.betweenness.tmax}
\title{Theoretical maximum for betweenness centralization}
\usage{
centr_betw_tmax(graph = NULL, nodes = 0, directed = TRUE)
}
\arguments{
\item{graph}{The input graph. It can also be \code{NULL}, if
\code{nodes} is given.}

\item{nodes}{The number of vertices. This is ignored if the graph is
given.}

\item{directed}{logical scalar, whether to use directed shortest paths
for calculating betweenness.}
}
\value{
Real scalar, the theoretical maximum (unnormalized) graph
betweenness centrality score for graphs with given order and other
parameters.
}
\description{
See \code{\link[=centralize]{centralize()}} for a summary of graph centralization.
}
\examples{
# A BA graph is quite centralized
g <- sample_pa(1000, m = 4)
centr_betw(g, normalized = FALSE)$centralization \%>\%
  `/`(centr_betw_tmax(g))
centr_betw(g, normalized = TRUE)$centralization
}
\seealso{
Other centralization related: 
\code{\link{centr_betw}()},
\code{\link{centr_clo_tmax}()},
\code{\link{centr_clo}()},
\code{\link{centr_degree_tmax}()},
\code{\link{centr_degree}()},
\code{\link{centr_eigen_tmax}()},
\code{\link{centr_eigen}()},
\code{\link{centralize}()}
}
\concept{centralization related}
