% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_edge_betweenness}
\alias{cluster_edge_betweenness}
\alias{edge.betweenness.community}
\title{Community structure detection based on edge betweenness}
\usage{
cluster_edge_betweenness(
  graph,
  weights = NULL,
  directed = TRUE,
  edge.betweenness = TRUE,
  merges = TRUE,
  bridges = TRUE,
  modularity = TRUE,
  membership = TRUE
)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. Edge weights
are used to calculate weighted edge betweenness. This means that edges are
interpreted as distances, not as connection strengths.}

\item{directed}{Logical constant, whether to calculate directed edge
betweenness for directed graphs. It is ignored for undirected graphs.}

\item{edge.betweenness}{Logical constant, whether to return the edge
betweenness of the edges at the time of their removal.}

\item{merges}{Logical constant, whether to return the merge matrix
representing the hierarchical community structure of the network.  This
argument is called \code{merges}, even if the community structure algorithm
itself is divisive and not agglomerative: it builds the tree from top to
bottom. There is one line for each merge (i.e. split) in matrix, the first
line is the first merge (last split). The communities are identified by
integer number starting from one. Community ids smaller than or equal to
\eqn{N}, the number of vertices in the graph, belong to singleton
communities, i.e. individual vertices. Before the first merge we have \eqn{N}
communities numbered from one to \eqn{N}. The first merge, the first line of
the matrix creates community \eqn{N+1}, the second merge creates community
\eqn{N+2}, etc.}

\item{bridges}{Logical constant, whether to return a list the edge removals
which actually splitted a component of the graph.}

\item{modularity}{Logical constant, whether to calculate the maximum
modularity score, considering all possibly community structures along the
edge-betweenness based edge removals.}

\item{membership}{Logical constant, whether to calculate the membership
vector corresponding to the highest possible modularity score.}
}
\value{
\code{cluster_edge_betweenness()} returns a
\code{\link[=communities]{communities()}} object, please see the \code{\link[=communities]{communities()}}
manual page for details.
}
\description{
Many networks consist of modules which are densely connected themselves but
sparsely connected to other modules.
}
\details{
The edge betweenness score of an edge measures the number of shortest paths
through it, see \code{\link[=edge_betweenness]{edge_betweenness()}} for details. The idea of the
edge betweenness based community structure detection is that it is likely
that edges connecting separate modules have high edge betweenness as all the
shortest paths from one module to another must traverse through them. So if
we gradually remove the edge with the highest edge betweenness score we will
get a hierarchical map, a rooted tree, called a dendrogram of the graph. The
leafs of the tree are the individual vertices and the root of the tree
represents the whole graph.

\code{cluster_edge_betweenness()} performs this algorithm by calculating the
edge betweenness of the graph, removing the edge with the highest edge
betweenness score, then recalculating edge betweenness of the edges and
again removing the one with the highest score, etc.

\code{edge.betweeness.community} returns various information collected
through the run of the algorithm. See the return value down here.
}
\examples{

g <- sample_pa(100, m = 2, directed = FALSE)
eb <- cluster_edge_betweenness(g)

g <- make_full_graph(10) \%du\% make_full_graph(10)
g <- add_edges(g, c(1, 11))
eb <- cluster_edge_betweenness(g)
eb

}
\references{
M Newman and M Girvan: Finding and evaluating community
structure in networks, \emph{Physical Review E} 69, 026113 (2004)
}
\seealso{
\code{\link[=edge_betweenness]{edge_betweenness()}} for the definition and calculation
of the edge betweenness, \code{\link[=cluster_walktrap]{cluster_walktrap()}},
\code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}},
\code{\link[=cluster_leading_eigen]{cluster_leading_eigen()}} for other community detection
methods.

See \code{\link[=communities]{communities()}} for extracting the results of the community
detection.

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{community}
\keyword{graphs}
