% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{hub_score}
\alias{hub_score}
\alias{hub.score}
\alias{authority_score}
\alias{authority.score}
\title{Kleinberg's hub and authority centrality scores.}
\usage{
hub_score(graph, scale = TRUE, weights = NULL, options = arpack_defaults)

authority_score(graph, scale = TRUE, weights = NULL, options = arpack_defaults)
}
\arguments{
\item{graph}{The input graph.}

\item{scale}{Logical scalar, whether to scale the result to have a maximum
score of one. If no scaling is used then the result vector has unit length
in the Euclidean norm.}

\item{weights}{Optional positive weight vector for calculating weighted
scores. If the graph has a \code{weight} edge attribute, then this is used
by default.
This function interprets edge weights as connection strengths. In the
random surfer model, an edge with a larger weight is more likely to be
selected by the surfer.}

\item{options}{A named list, to override some ARPACK options. See
\code{\link[=arpack]{arpack()}} for details.}
}
\value{
A named list with members:
\item{vector}{The hub or authority scores of the vertices.}
\item{value}{The corresponding eigenvalue of the calculated
principal eigenvector.}
\item{options}{Some information about the ARPACK computation, it has
the same members as the \code{options} member returned
by \code{\link[=arpack]{arpack()}}, see that for documentation.}
}
\description{
The hub scores of the vertices are defined as the principal eigenvector
of \eqn{A A^T}{A*t(A)}, where \eqn{A} is the adjacency matrix of the
graph.
}
\details{
Similarly, the authority scores of the vertices are defined as the principal
eigenvector of \eqn{A^T A}{t(A)*A}, where \eqn{A} is the adjacency matrix of
the graph.

For undirected matrices the adjacency matrix is symmetric and the hub
scores are the same as authority scores.
}
\examples{
## An in-star
g <- make_star(10)
hub_score(g)$vector
authority_score(g)$vector

## A ring
g2 <- make_ring(10)
hub_score(g2)$vector
authority_score(g2)$vector
}
\references{
J. Kleinberg. Authoritative sources in a hyperlinked
environment. \emph{Proc. 9th ACM-SIAM Symposium on Discrete Algorithms},
1998. Extended version in \emph{Journal of the ACM} 46(1999). Also appears
as IBM Research Report RJ 10076, May 1997.
}
\seealso{
\code{\link[=eigen_centrality]{eigen_centrality()}} for eigenvector centrality,
\code{\link[=page_rank]{page_rank()}} for the Page Rank scores. \code{\link[=arpack]{arpack()}} for
the underlining machinery of the computation.

Centrality measures
\code{\link{alpha_centrality}()},
\code{\link{betweenness}()},
\code{\link{closeness}()},
\code{\link{diversity}()},
\code{\link{eigen_centrality}()},
\code{\link{harmonic_centrality}()},
\code{\link{page_rank}()},
\code{\link{power_centrality}()},
\code{\link{spectrum}()},
\code{\link{strength}()},
\code{\link{subgraph_centrality}()}
}
\concept{centrality}
