% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_louvain}
\alias{cluster_louvain}
\title{Finding community structure by multi-level optimization of modularity}
\usage{
cluster_louvain(graph, weights = NULL, resolution = 1)
}
\arguments{
\item{graph}{The input graph.}

\item{weights}{The weights of the edges. It must be a positive numeric vector,
\code{NULL} or \code{NA}. If it is \code{NULL} and the input graph has a
\sQuote{weight} edge attribute, then that attribute will be used. If
\code{NULL} and no such attribute is present, then the edges will have equal
weights. Set this to \code{NA} if the graph was a \sQuote{weight} edge
attribute, but you don't want to use it for community detection. A larger
edge weight means a stronger connection for this function.}

\item{resolution}{Optional resolution parameter that allows the user to
adjust the resolution parameter of the modularity function that the algorithm
uses internally. Lower values typically yield fewer, larger clusters. The
original definition of modularity is recovered when the resolution parameter
is set to 1.}
}
\value{
\code{cluster_louvain()} returns a \code{\link[=communities]{communities()}}
object, please see the \code{\link[=communities]{communities()}} manual page for details.
}
\description{
This function implements the multi-level modularity optimization algorithm
for finding community structure, see references below. It is based on the
modularity measure and a hierarchical approach.
}
\details{
This function implements the multi-level modularity optimization algorithm
for finding community structure, see VD Blondel, J-L Guillaume, R Lambiotte
and E Lefebvre: Fast unfolding of community hierarchies in large networks,
\url{https://arxiv.org/abs/0803.0476} for the details.

It is based on the modularity measure and a hierarchical approach.
Initially, each vertex is assigned to a community on its own. In every step,
vertices are re-assigned to communities in a local, greedy way: each vertex
is moved to the community with which it achieves the highest contribution to
modularity. When no vertices can be reassigned, each community is considered
a vertex on its own, and the process starts again with the merged
communities. The process stops when there is only a single vertex left or
when the modularity cannot be increased any more in a step. Since igraph 1.3,
vertices are processed in a random order.

This function was contributed by Tom Gregorovic.
}
\examples{

# This is so simple that we will have only one level
g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1, 6, 1, 11, 6, 11))
cluster_louvain(g)

}
\references{
Vincent D. Blondel, Jean-Loup Guillaume, Renaud Lambiotte,
Etienne Lefebvre: Fast unfolding of communities in large networks. J. Stat.
Mech. (2008) P10008
}
\seealso{
See \code{\link[=communities]{communities()}} for extracting the membership,
modularity scores, etc. from the results.

Other community detection algorithms: \code{\link[=cluster_walktrap]{cluster_walktrap()}},
\code{\link[=cluster_spinglass]{cluster_spinglass()}},
\code{\link[=cluster_leading_eigen]{cluster_leading_eigen()}},
\code{\link[=cluster_edge_betweenness]{cluster_edge_betweenness()}},
\code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}},
\code{\link[=cluster_label_prop]{cluster_label_prop()}}
\code{\link[=cluster_leiden]{cluster_leiden()}}

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_fluid_communities}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()}
}
\author{
Tom Gregorovic, Tamas Nepusz \email{ntamas@gmail.com}
}
\concept{community}
\keyword{graphs}
