% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_denue_grid.R
\name{denue_grid}
\alias{denue_grid}
\title{Businesses in a grid larger than 5 kms}
\usage{
denue_grid(lat1, lat2, lon1, lon2, token, metros = 5000, keyword = "todos",
  espacio_lat = 0.07, espacio_lon = 0.07, unicos = TRUE)
}
\arguments{
\item{lat1}{First corner (latitud)}

\item{lat2}{Second corner (latitud)}

\item{lon1}{First corner (longitud)}

\item{lon2}{Second corner (longitud)}

\item{token}{API token supplied by INEGI}

\item{metros}{Distance in meters to search by coordinate}

\item{keyword}{Keyword of businesses to include. Defaults to all ("todos")}

\item{espacio_lat}{Space between latitud coordinates defaults to 0.07 degrees}

\item{espacio_lon}{Space between longitud coordinates defaults to 0.07 degrees}

\item{unicos}{Default = TRUE, eliminates duplicate businesses}
}
\value{
Data.frame
}
\description{
Returns data.frame with businesses registered in the DENUE in spaces larger than 5 kilometers.
Calls \code{make_grid}. Functions contributed by Arturo Cardenas \url{https://github.com/arturocm}.
}
\details{
Makes a loop for each pair of coordinates, creating a grid to extract businesses inside. Uses maximum and minimum coordinate pairs to draw frame.
}
\note{
Legacy function, will return data in spanish.
}
\examples{
\dontrun{
token<-"webservice_token"
latitud1 <- "25.669194"
latitud2 <- "25.169194"
longitud1 <- "-100.30990"
longitud2 <- "-101.20102"
Negocios <- denue_grid(latitud1, latitud2, longitud1, longitud2, token)
}

}
\author{
Arturo Cardenas
}
