% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_legacy.R
\name{legacy_state}
\alias{legacy_state}
\alias{series_PIB_estados}
\alias{series_crecimiento_regiones}
\alias{series_ITAE_estados}
\title{State functions in spanish}
\usage{
series_PIB_estados(token)

series_crecimiento_regiones(token)

series_ITAE_estados(token)
}
\arguments{
\item{token}{API token supplied by INEGI}
}
\value{
Data.frame
}
\description{
Each of these functions return data in the previous (v1.2) format in spanish and have no interchangeable pair in english. 
See the examples for each series meaning.
}
\details{
For detail of calculation of growth by regions, refer to: \url{http://enelmargen.org/eem/regiones/index.html}
}
\note{
Legacy functions, will return data in spanish.
}
\examples{
\dontrun{
token <- "webservice_token"
# GDP by state
dat <- series_PIB_estados(token)
# Growth by regions (see details)
dat <- series_crecimiento_regiones(token)
# Trimestral economic activity indicator, by state
dat <- series_ITAE_estados(token)
}
}
\author{
Eduardo Flores
}
