% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetInsetLocation.R
\name{GetInsetLocation}
\alias{GetInsetLocation}
\title{Get Location for Inset in Plot}
\usage{
GetInsetLocation(dx, dy, loc = "bottomright", inset = 0, pad = 0, padin = 0)
}
\arguments{
\item{dx, dy}{'numeric' number.
Width and height of the inset, respectively.}

\item{loc}{'character' string.
Single keyword used to specify the position of the inset in the main plot region:
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"},
\code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"},
or \code{"center"} to denote inset location.}

\item{inset}{'numeric' vector of length 1 or 2, value is recycled as necessary.
Inset distance from the margins as a fraction of the main plot region.}

\item{pad}{'numeric' vector of length 1 or 2, value is recycled as necessary.
Padding distance from the margins in user coordinate units.}

\item{padin}{'numeric' vector of length 1 or 2, value is recycled as necessary.
Padding distance from the margins in inches.}
}
\value{
A 'numeric' vector of length 2 giving the user coordinates
  for the bottom-left corner of the inset.
}
\description{
Calculate \emph{x} and \emph{y} co-ordinates that can be used to
position an inset in a plot frame at a specified keyword location.
}
\examples{
plot(NA, NA, xlim = c(0, 100), ylim = c(0, 1),
     xlab = "x", ylab = "y", xaxs = "i", yaxs = "i")
dx <- 20; dy <- 0.2
xy <- GetInsetLocation(dx, dy, loc = "bottomleft")
rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "red")
points(xy[1], xy[2], pch = 16, xpd = TRUE)
print(xy)

xy <- GetInsetLocation(dx, dy, loc = "bottomleft", inset = 0.05)
rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "pink")
points(xy[1], xy[2], pch = 16)
print(xy)

xy <- GetInsetLocation(dx, dy, loc = "topright", padin = 0.5)
rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "blue")

xy <- GetInsetLocation(dx, dy, loc = "left", pad = c(5, 0))
rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "green")

xy <- GetInsetLocation(dx, dy, loc = "center")
rect(xy[1], xy[2], xy[1] + dx, xy[2] + dy, border = "brown")

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
