/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.toolkit.ColorBridge;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimCircle;
import org.rosuda.pograss.PoGraSS;

public class PPrimPolygon
extends PPrimBase {
    public Polygon pg;
    public boolean drawBorder = true;
    public boolean useSelAlpha = true;
    public boolean closed = true;
    public boolean fill = true;
    public boolean selectByCorners = false;
    public boolean drawCorners = false;
    public float[] lineWidth;
    public boolean[] invisibleLines;
    public boolean showInvisibleLines = false;
    private boolean[] gapDots;
    public boolean[] noDotsAt;
    public boolean showGapDots = true;
    private List gapDotPs;
    public Color COL_INVISIBLELINES = new Color(255, 255, 0);
    private int nodeSize = 2;

    public boolean contains(int n, int n2) {
        int n3;
        if (this.pg == null) {
            return false;
        }
        if (this.fill) {
            return this.pg.contains((double)n, (double)n2);
        }
        if (this.drawCorners) {
            for (n3 = 0; n3 < this.pg.npoints; ++n3) {
                if ((n - this.pg.xpoints[n3]) * (n - this.pg.xpoints[n3]) + (n2 - this.pg.ypoints[n3]) * (n2 - this.pg.ypoints[n3]) > this.nodeSize * this.nodeSize) continue;
                return true;
            }
        }
        if (this.drawBorder) {
            for (n3 = 1; n3 < this.pg.npoints; ++n3) {
                double d;
                double d2;
                if (this.invisibleLines != null && this.invisibleLines[n3 - 1]) continue;
                int n4 = Math.min(this.pg.ypoints[n3 - 1], this.pg.ypoints[n3]);
                int n5 = Math.max(this.pg.ypoints[n3 - 1], this.pg.ypoints[n3]);
                if (n < this.pg.xpoints[n3 - 1] || n > this.pg.xpoints[n3] || n2 < n4 || n2 > n5 || !((d2 = Math.abs((double)this.pg.ypoints[n3 - 1] + (d = (double)(n - this.pg.xpoints[n3 - 1]) / (double)(this.pg.xpoints[n3] - this.pg.xpoints[n3 - 1])) * (double)(this.pg.ypoints[n3] - this.pg.ypoints[n3 - 1]) - (double)n2)) <= 1.0)) continue;
                return true;
            }
        }
        if (this.gapDotPs != null) {
            Iterator iterator = this.gapDotPs.iterator();
            while (iterator.hasNext()) {
                if (!((PPrimCircle)iterator.next()).contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle rectangle) {
        int n;
        if (this.pg == null) {
            return false;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.fill) {
            return this.pg.intersects(double_);
        }
        if (this.selectByCorners) {
            for (n = 0; n < this.pg.npoints; ++n) {
                if (!new Ellipse2D.Double(this.pg.xpoints[n] - this.nodeSize, this.pg.ypoints[n] - this.nodeSize, 2 * this.nodeSize + 1, 2 * this.nodeSize + 1).intersects(double_)) continue;
                return true;
            }
        } else {
            for (n = 1; n < this.pg.npoints; ++n) {
                Line2D.Double double_2;
                if (this.invisibleLines != null && this.invisibleLines[n - 1] || !(double_2 = new Line2D.Double(this.pg.xpoints[n - 1], this.pg.ypoints[n - 1], this.pg.xpoints[n], this.pg.ypoints[n])).intersects(double_)) continue;
                return true;
            }
        }
        if (this.gapDotPs != null) {
            Iterator iterator = this.gapDotPs.iterator();
            while (iterator.hasNext()) {
                if (!((PPrimCircle)iterator.next()).intersects(rectangle)) continue;
                return true;
            }
        }
        return false;
    }

    public void paint(PoGraSS poGraSS, int n, SMarker sMarker) {
        Object object;
        if (this.pg == null) {
            return;
        }
        int n2 = sMarker.getSec(this.ref[0]);
        if (this.fill) {
            object = n2 > 0 ? ColorBridge.getMain().getColor(n2) : null;
            this.paintPolygon(poGraSS, n, sMarker, false, this.borderColor, (Color)object);
        } else {
            object = n2 > 0 ? ColorBridge.getMain().getColor(n2) : this.borderColor;
            this.paintPolygon(poGraSS, n, sMarker, false, (Color)object, this.fillColor);
        }
        if (this.showGapDots && this.gapDots != null) {
            object = this.gapDotPs.iterator();
            while (object.hasNext()) {
                ((PPrimCircle)object.next()).paint(poGraSS, n, sMarker);
            }
        }
    }

    public void paintSelected(PoGraSS poGraSS, int n, SMarker sMarker) {
        if (this.pg == null) {
            return;
        }
        int n2 = sMarker.get(this.ref[0]);
        if (n2 == -1) {
            this.paintPolygon(poGraSS, n, sMarker, true, this.borderColorSel, this.fillColorSel);
        }
        if (this.showGapDots && this.gapDots != null) {
            Iterator iterator = this.gapDotPs.iterator();
            while (iterator.hasNext()) {
                ((PPrimCircle)iterator.next()).paintSelected(poGraSS, n, sMarker);
            }
        }
    }

    public String toString() {
        return "PPrimPolygon(" + (this.pg == null ? "<null polygon>" : "" + this.pg.npoints + " points") + ", drawBorder=" + this.drawBorder + ", useSelAlpha=" + this.useSelAlpha + ")";
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public void setNodeSize(int n) {
        if (n > 0) {
            this.nodeSize = n;
        }
    }

    private void paintPolygon(PoGraSS poGraSS, int n, SMarker sMarker, boolean bl, Color color, Color color2) {
        int n2;
        if (this.fill) {
            if (color2 != null) {
                poGraSS.setColor(color2);
            } else {
                poGraSS.setColor(Common.objectsColor);
            }
            poGraSS.fillPolygon(this.pg.xpoints, this.pg.ypoints, this.pg.npoints);
        }
        if (this.drawBorder) {
            poGraSS.setColor(color);
            for (n2 = 1; n2 < this.pg.npoints; ++n2) {
                if (this.invisibleLines != null && this.invisibleLines[n2 - 1]) continue;
                if (this.lineWidth != null) {
                    poGraSS.setLineWidth(this.lineWidth[n2 - 1]);
                }
                poGraSS.drawLine(this.pg.xpoints[n2 - 1], this.pg.ypoints[n2 - 1], this.pg.xpoints[n2], this.pg.ypoints[n2]);
            }
            if (this.closed) {
                if (this.lineWidth != null) {
                    poGraSS.setLineWidth(this.lineWidth[this.pg.npoints - 1]);
                }
                poGraSS.drawLine(this.pg.xpoints[this.pg.npoints - 1], this.pg.ypoints[this.pg.npoints - 1], this.pg.xpoints[0], this.pg.ypoints[0]);
            }
            if (!bl && this.showInvisibleLines && this.invisibleLines != null) {
                poGraSS.setColor(this.COL_INVISIBLELINES);
                for (n2 = 0; n2 < this.invisibleLines.length - 1; ++n2) {
                    if (!this.invisibleLines[n2]) continue;
                    poGraSS.drawLine(this.pg.xpoints[n2], this.pg.ypoints[n2], this.pg.xpoints[n2 + 1], this.pg.ypoints[n2 + 1]);
                }
            }
        }
        if (this.drawCorners) {
            poGraSS.setColor(color);
            for (n2 = 0; n2 < this.pg.npoints; ++n2) {
                if (this.noDotsAt != null && this.noDotsAt[n2]) continue;
                poGraSS.fillOval(this.pg.xpoints[n2] - this.nodeSize, this.pg.ypoints[n2] - this.nodeSize, 2 * this.nodeSize + 1, 2 * this.nodeSize + 1);
            }
        }
    }

    public void setGapDots(boolean[] blArray) {
        this.gapDots = blArray;
        if (blArray != null) {
            if (this.gapDotPs == null) {
                this.gapDotPs = new ArrayList(blArray.length / 2);
            } else {
                this.gapDotPs.clear();
            }
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                PPrimCircle pPrimCircle = new PPrimCircle();
                pPrimCircle.x = this.pg.xpoints[i];
                pPrimCircle.y = this.pg.ypoints[i];
                pPrimCircle.diam = 2 * this.nodeSize + 1;
                pPrimCircle.ref = this.ref;
                pPrimCircle.fillColor = this.COL_OUTLINE;
                this.gapDotPs.add(pPrimCircle);
            }
        }
    }

    public void setPolygon(Polygon polygon) {
        this.pg = polygon;
    }
}

