% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{iv.diagnosis}
\alias{iv.diagnosis}
\alias{iv.diagnosis.plot}
\title{Diagnostics of instrumental variable analysis}
\usage{
iv.diagnosis(Y, D, Z, X)

iv.diagnosis.plot(output, bias.ratio = TRUE, base_size = 15,
  text_size = 5)
}
\arguments{
\item{Y}{A numeric vector of outcomes.}

\item{D}{A vector of endogenous variables.}

\item{Z}{A vector of instruments.}

\item{X}{A vector, matrix or data frame of (exogenous) covariates.}

\item{output}{Output from \code{iv.diagnosis}.}

\item{bias.ratio}{Add bias ratios (text) to the plot?}

\item{base_size}{size of the axis labels}

\item{text_size}{size of the text (bias ratios)}
}
\value{
a list or data frame
\describe{
\item{x.mean1}{Mean of X under Z = 1 (reported if Z is binary)}
\item{x.mean0}{Mean of X under Z = 0 (reported if Z is binary)}
\item{coef}{OLS coefficient of X ~ Z (reported if Z is not binary)}
\item{se}{Standard error of OLS coefficient (reported if Z is not binary)}
\item{p.val}{p-value of the independence of Z and X (Fisher's test if both are binary, logistic regression if Z is binary, linear regression if Z is continuous)}
\item{stand.diff}{Standardized difference (reported if Z is binary)}
\item{bias.ratio}{Bias ratio}
\item{bias.amplify}{Amplification of bias ratio}
\item{bias.ols}{Bias of OLS}
\item{bias.2sls}{Bias of two stage least squares)}
}
}
\description{
Diagnostics of instrumental variable analysis
}
\section{Functions}{
\itemize{
\item \code{iv.diagnosis.plot}: IV diagnostic plot
}}

\examples{
n <- 10000
Z <- rbinom(n, 1, 0.5)
X <- data.frame(matrix(c(rnorm(n), rbinom(n * 5, 1, 0.5)), n))
D <- rbinom(n, 1, plogis(Z + X[, 1] + X[, 2] + X[, 3]))
Y <- D + X[, 1] + X[, 2] + rnorm(n)
print(output <- iv.diagnosis(Y, D, Z, X))
iv.diagnosis.plot(output)

Z <- rnorm(n)
D <- rbinom(n, 1, plogis(Z + X[, 1] + X[, 2] + X[, 3]))
Y <- D + X[, 1] + X[, 2] + rnorm(n)
print(output <- iv.diagnosis(Y, D, Z, X)) ## stand.diff is not reported
iv.diagnosis.plot(output)

}
\references{
\itemize{
\item{Baiocchi, M., Cheng, J., & Small, D. S. (2014). Instrumental variable methods for causal inference. Statistics in Medicine, 33(13), 2297-2340.}
\item{Jackson, J. W., & Swanson, S. A. (2015). Toward a clearer portrayal of confounding bias in instrumental variable applications. Epidemiology, 26(4), 498.}
\item{Zhao, Q., & Small, D. S. (2018). Graphical diagnosis of confounding bias in instrumental variable analysis. Epidemiology, 29(4), e29--e31.}
}
}
\author{
Qingyuan Zhao
}
