\name{card.data}
\alias{card.data}
\docType{data}
\title{
card.data
%%   ~~ data name/kind ... ~~
}
\description{
Data from the National Longitudinal Survey of Young Men (NLSYM) that was used by Card (1995).
%%  ~~ A concise (1-5 lines) description of the dataset. ~~
}
\usage{data(card.data)}
\format{
  A data frame with 3010 observations on the following 35 variables.
  \describe{
    \item{\code{id}}{subject id}
    \item{\code{nearc2}}{indicator for whether a subject grew up near a two-year college}
    \item{\code{nearc4}}{indicator for whether a subject grew up near a four-year college}
    \item{\code{educ}}{subject's years of education}
    \item{\code{age}}{subject's age at the time of the survey in 1976}
    \item{\code{fatheduc}}{subject's father's years of education}
    \item{\code{motheduc}}{subject's mother's years of education}
    \item{\code{weight}}{sampling weight}
    \item{\code{momdad14}}{indicator for whether subject lived with both mother and father at age 14}
    \item{\code{sinmom14}}{indicator for whether subject lived with single mom at age 14}
    \item{\code{step14}}{indicator for whehter subject lived with step-parent at age 14}
    \item{\code{reg661}}{indicator for whether subject lived in region 1 (New England) in 1966}
    \item{\code{reg662}}{indicator for whether subject lived in region 2 (Middle Atlantic) in 1966}
    \item{\code{reg663}}{indicator for whether subject lived in region 3 (East North Central) in 1966}
    \item{\code{reg664}}{indicator for whether subject lived in region 4 (West North Central) in 1966}
    \item{\code{reg665}}{indicator for whether subject lived in region 5 (South Atlantic) in 1966}
    \item{\code{reg666}}{indicator for whether subject lived in region 6 (East South Central) in 1966}
    \item{\code{reg667}}{indicator for whether subject lived in region 7 (West South Central) in 1966}
    \item{\code{reg668}}{indicator for whether subject lived in region 8 (Mountain) in 1966}
    \item{\code{reg669}}{indicator for whether subject lived in region 9 (Pacific) in 1966}
    \item{\code{south66}}{indicator for whether subject lived in South in 1966}
    \item{\code{black}}{indicator for whether subject's race is black}
    \item{\code{smsa}}{indicator for whether subject lived in SMSA in 1976}
    \item{\code{south}}{indicator for whether subject lived in the South in 1976}
    \item{\code{smsa66}}{indicator for whether subject lived in SMSA in 1966}
    \item{\code{wage}}{subject's wage in cents per hour in 1976}
    \item{\code{enroll}}{indicator for whether subject is enrolled in college in 1976}
    \item{\code{KWW}}{subject's score on the Knowledge of the World of Work (KWW) test in 1966}
    \item{\code{IQ}}{IQ-type test score collected from the high school of the subject.}
    \item{\code{married}}{indicator for whether the subject was married in 1976.}
    \item{\code{libcrd14}}{indicator for whether subject had library card at age 14.}
    \item{\code{exper}}{subject's years of labor force experience in 1976}
    \item{\code{lwage}}{subject's log wage in 1976}
    \item{\code{expersq}}{square of subject's years of labor force experience in 1976}
    \item{\code{region}}{region in which subject lived in 1976}
  }
}
\source{
Card, D.  Using Geographic Variation in College Proximity to Estimate the Return to Schooling. In Aspects of Labor Market Behavior: Essays in Honor of John Vanderkamp, eds. L.N. Christophides, E.K. Grant and R. Swidinsky.  201-222. 
National Longitudinal Survey of Young Men: https://www.nlsinfo.org/investigator/pages/login.jsp
%%  ~~ reference to a publication or URL from which the data were obtained ~~
}
\examples{
data(card.data)
}
\keyword{datasets}
