# this is an internal file providing language support.
# please refer to inst/README.languages for details

set.lang.support("hyphen",
	list(
		"ru"="ru"
	)
)

set.lang.support("treetag",
	list("ru"=list(
		## preset: "ru"
		lang="ru",
		encoding="",
		preset=function(TT.cmd, TT.bin, TT.lib, unix.OS){
			if(isTRUE(unix.OS)){
				# preset for unix systems
				return(
					list(
						TT.tokenizer		= file.path(TT.cmd, "utf8-tokenize.perl"),
						TT.tagger			= file.path(TT.bin, "tree-tagger"),
						TT.abbrev			= c(),
						TT.params			= file.path(TT.lib, "russian.par"),

						TT.tknz.opts.def	= c(),
						TT.tknz.opts		= c(),
						TT.lookup.command	= c(),
						TT.filter.command	= c()
					)
				)
			} else {
				# preset for windows systems
				return(
					list(
						TT.tokenizer		= file.path(TT.cmd, "utf8-tokenize.perl"),
						TT.tagger			= file.path(TT.bin, "tree-tagger.exe"),
						TT.abbrev			= c(),
						TT.params			= file.path(TT.lib, "russian.par"),

						TT.tknz.opts.def	= c(),
						TT.tknz.opts		= c(),
						TT.lookup.command	= c(),
						TT.filter.command	= c()
					)
				)
			}
		})
	)
)

set.lang.support("kRp.POS.tags",
	## tag and class definitions
	# ru -- russian
	# see http://corpus.leeds.ac.uk/mocky/
	list("ru"=list(
		tag.class.def.words=matrix(c(
			"Afp", "adjective", "Adjective Type=qualificative Degree=positive",
			"Afp-p-s", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Definiteness=short-art",
			"Afp-pn", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=nominative",
			"Afp-pnf", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=nominative Definiteness=full-art",
			"Afp-pg", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=genitive",
			"Afp-pgf", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=genitive Definiteness=full-art",
			"Afp-pd", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=dative",
			"Afp-pdf", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=dative Definiteness=full-art",
			"Afp-pa", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=accusative",
			"Afp-paf", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=accusative Definiteness=full-art",
			"Afp-pl", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=locative",
			"Afp-plf", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=locative Definiteness=full-art",
			"Afp-pi", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=instrumental",
			"Afp-pif", "adjective", "Adjective Type=qualificative Degree=positive Number=plural Case=instrumental Definiteness=full-art",
			"Afpms-s", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Definiteness=short-art",
			"Afpmsn", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=nominative",
			"Afpmsnf", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=nominative Definiteness=full-art",
			"Afpmsg", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=genitive",
			"Afpmsgf", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=genitive Definiteness=full-art",
			"Afpmsd", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=dative",
			"Afpmsdf", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=dative Definiteness=full-art",
			"Afpmsa", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=accusative",
			"Afpmsaf", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=accusative Definiteness=full-art",
			"Afpmsl", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=locative",
			"Afpmslf", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=locative Definiteness=full-art",
			"Afpmsi", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=instrumental",
			"Afpmsif", "adjective", "Adjective Type=qualificative Degree=positive Gender=masculine Number=singular Case=instrumental Definiteness=full-art",
			"Afpfs-s", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Definiteness=short-art",
			"Afpfs-f", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Definiteness=full-art",
			"Afpfsn", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=nominative",
			"Afpfsnf", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=nominative Definiteness=full-art",
			"Afpfsg", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=genitive",
			"Afpfsgf", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=genitive Definiteness=full-art",
			"Afpfsd", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=dative",
			"Afpfsdf", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=dative Definiteness=full-art",
			"Afpfsa", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=accusative",
			"Afpfsaf", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=accusative Definiteness=full-art",
			"Afpfsl", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=locative",
			"Afpfslf", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=locative Definiteness=full-art",
			"Afpfsi", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=instrumental",
			"Afpfsif", "adjective", "Adjective Type=qualificative Degree=positive Gender=feminine Number=singular Case=instrumental Definiteness=full-art",
			"Afpns-s", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Definiteness=short-art",
			"Afpnsn", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=nominative",
			"Afpnsnf", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=nominative Definiteness=full-art",
			"Afpnsg", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=genitive",
			"Afpnsgf", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=genitive Definiteness=full-art",
			"Afpnsd", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=dative",
			"Afpnsdf", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=dative Definiteness=full-art",
			"Afpnsa", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=accusative",
			"Afpnsaf", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=accusative Definiteness=full-art",
			"Afpnsl", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=locative",
			"Afpnslf", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=locative Definiteness=full-art",
			"Afpnsi", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=instrumental",
			"Afpnsif", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=singular Case=instrumental Definiteness=full-art",
			"Afpnpif", "adjective", "Adjective Type=qualificative Degree=positive Gender=neuter Number=plural Case=instrumental Definiteness=full-art",
			"Afc", "adjective", "Adjective Type=qualificative Degree=comparative",
			"Afc---f", "adjective", "Adjective Type=qualificative Degree=comparative Definiteness=full-art",
			"C", "conjunction", "Conjunction",
			"I", "interjection", "Interjection",
			"Mpmsn----y", "number", "Numeral Type=*p Gender=masculine Number=singular Case=nominative Animate=yes",
			"Mc", "number", "Numeral Type=cardinal",
			"Mc--n", "number", "Numeral Type=cardinal Case=nominative",
			"Mc--g", "number", "Numeral Type=cardinal Case=genitive",
			"Mc--d", "number", "Numeral Type=cardinal Case=dative",
			"Mc--a", "number", "Numeral Type=cardinal Case=accusative",
			"Mc--l", "number", "Numeral Type=cardinal Case=locative",
			"Mc--i", "number", "Numeral Type=cardinal Case=instrumental",
			"Mc-s", "number", "Numeral Type=cardinal Number=singular",
			"Mcm-n", "number", "Numeral Type=cardinal Gender=masculine Case=nominative",
			"Mcm-d", "number", "Numeral Type=cardinal Gender=masculine Case=dative",
			"Mcm-a", "number", "Numeral Type=cardinal Gender=masculine Case=accusative",
			"Mcm-i", "number", "Numeral Type=cardinal Gender=masculine Case=instrumental",
			"Mcf-n", "number", "Numeral Type=cardinal Gender=feminine Case=nominative",
			"Mcf-g", "number", "Numeral Type=cardinal Gender=feminine Case=genitive",
			"Mcf-d", "number", "Numeral Type=cardinal Gender=feminine Case=dative",
			"Mcf-a", "number", "Numeral Type=cardinal Gender=feminine Case=accusative",
			"Mcf-l", "number", "Numeral Type=cardinal Gender=feminine Case=locative",
			"Mcf-i", "number", "Numeral Type=cardinal Gender=feminine Case=instrumental",
			"Mcn-n", "number", "Numeral Type=cardinal Gender=neuter Case=nominative",
			"Mcn-g", "number", "Numeral Type=cardinal Gender=neuter Case=genitive",
			"Mcn-d", "number", "Numeral Type=cardinal Gender=neuter Case=dative",
			"Mcn-a", "number", "Numeral Type=cardinal Gender=neuter Case=accusative",
			"Mcn-l", "number", "Numeral Type=cardinal Gender=neuter Case=locative",
			"Mcn-i", "number", "Numeral Type=cardinal Gender=neuter Case=instrumental",
			"Mo", "number", "Numeral Type=ordinal",
			"Mo--g", "number", "Numeral Type=ordinal Case=genitive",
			"Mo-pn", "number", "Numeral Type=ordinal Number=plural Case=nominative",
			"Mo-pg", "number", "Numeral Type=ordinal Number=plural Case=genitive",
			"Mo-pd", "number", "Numeral Type=ordinal Number=plural Case=dative",
			"Mo-pa", "number", "Numeral Type=ordinal Number=plural Case=accusative",
			"Mo-pl", "number", "Numeral Type=ordinal Number=plural Case=locative",
			"Mo-pi", "number", "Numeral Type=ordinal Number=plural Case=instrumental",
			"Momsn", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=nominative",
			"Momsg", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=genitive",
			"Momsd", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=dative",
			"Momsa", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=accusative",
			"Momsl", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=locative",
			"Momsi", "number", "Numeral Type=ordinal Gender=masculine Number=singular Case=instrumental",
			"Mofsn", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=nominative",
			"Mofsg", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=genitive",
			"Mofsd", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=dative",
			"Mofsa", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=accusative",
			"Mofsl", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=locative",
			"Mofsl----n", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=locative Animate=no",
			"Mofsi", "number", "Numeral Type=ordinal Gender=feminine Number=singular Case=instrumental",
			"Monsn", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=nominative",
			"Monsn----n", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=nominative Animate=no",
			"Monsg", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=genitive",
			"Monsg----n", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=genitive Animate=no",
			"Monsd", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=dative",
			"Monsa", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=accusative",
			"Monsl", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=locative",
			"Monsi", "number", "Numeral Type=ordinal Gender=neuter Number=singular Case=instrumental",
			"Monpg----n", "number", "Numeral Type=ordinal Gender=neuter Number=plural Case=genitive Animate=no",
			"Monpd----n", "number", "Numeral Type=ordinal Gender=neuter Number=plural Case=dative Animate=no",
			"Nc", "noun", "Noun Type=common",
			"Nc-pn", "noun", "Noun Type=common Number=plural Case=nominative",
			"Nc-pg", "noun", "Noun Type=common Number=plural Case=genitive",
			"Nc-pd", "noun", "Noun Type=common Number=plural Case=dative",
			"Nc-pa", "noun", "Noun Type=common Number=plural Case=accusative",
			"Nc-pl", "noun", "Noun Type=common Number=plural Case=locative",
			"Nc-pi", "noun", "Noun Type=common Number=plural Case=instrumental",
			"Ncmsnn", "noun", "Noun Type=common Gender=masculine Number=singular Case=nominative Animate=no",
			"Ncmsny", "noun", "Noun Type=common Gender=masculine Number=singular Case=nominative Animate=yes",
			"Ncmsgn", "noun", "Noun Type=common Gender=masculine Number=singular Case=genitive Animate=no",
			"Ncmsgy", "noun", "Noun Type=common Gender=masculine Number=singular Case=genitive Animate=yes",
			"Ncmsdn", "noun", "Noun Type=common Gender=masculine Number=singular Case=dative Animate=no",
			"Ncmsdy", "noun", "Noun Type=common Gender=masculine Number=singular Case=dative Animate=yes",
			"Ncmsan", "noun", "Noun Type=common Gender=masculine Number=singular Case=accusative Animate=no",
			"Ncmsay", "noun", "Noun Type=common Gender=masculine Number=singular Case=accusative Animate=yes",
			"Ncmsvy", "noun", "Noun Type=common Gender=masculine Number=singular Case=vocative Animate=yes",
			"Ncmsln", "noun", "Noun Type=common Gender=masculine Number=singular Case=locative Animate=no",
			"Ncmsly", "noun", "Noun Type=common Gender=masculine Number=singular Case=locative Animate=yes",
			"Ncmsin", "noun", "Noun Type=common Gender=masculine Number=singular Case=instrumental Animate=no",
			"Ncmsiy", "noun", "Noun Type=common Gender=masculine Number=singular Case=instrumental Animate=yes",
			"Ncmpnn", "noun", "Noun Type=common Gender=masculine Number=plural Case=nominative Animate=no",
			"Ncmpny", "noun", "Noun Type=common Gender=masculine Number=plural Case=nominative Animate=yes",
			"Ncmpgn", "noun", "Noun Type=common Gender=masculine Number=plural Case=genitive Animate=no",
			"Ncmpgy", "noun", "Noun Type=common Gender=masculine Number=plural Case=genitive Animate=yes",
			"Ncmpdn", "noun", "Noun Type=common Gender=masculine Number=plural Case=dative Animate=no",
			"Ncmpdy", "noun", "Noun Type=common Gender=masculine Number=plural Case=dative Animate=yes",
			"Ncmpan", "noun", "Noun Type=common Gender=masculine Number=plural Case=accusative Animate=no",
			"Ncmpay", "noun", "Noun Type=common Gender=masculine Number=plural Case=accusative Animate=yes",
			"Ncmpln", "noun", "Noun Type=common Gender=masculine Number=plural Case=locative Animate=no",
			"Ncmply", "noun", "Noun Type=common Gender=masculine Number=plural Case=locative Animate=yes",
			"Ncmpin", "noun", "Noun Type=common Gender=masculine Number=plural Case=instrumental Animate=no",
			"Ncmpiy", "noun", "Noun Type=common Gender=masculine Number=plural Case=instrumental Animate=yes",
			"Ncfsnn", "noun", "Noun Type=common Gender=feminine Number=singular Case=nominative Animate=no",
			"Ncfsny", "noun", "Noun Type=common Gender=feminine Number=singular Case=nominative Animate=yes",
			"Ncfsgn", "noun", "Noun Type=common Gender=feminine Number=singular Case=genitive Animate=no",
			"Ncfsgy", "noun", "Noun Type=common Gender=feminine Number=singular Case=genitive Animate=yes",
			"Ncfsdn", "noun", "Noun Type=common Gender=feminine Number=singular Case=dative Animate=no",
			"Ncfsdy", "noun", "Noun Type=common Gender=feminine Number=singular Case=dative Animate=yes",
			"Ncfsan", "noun", "Noun Type=common Gender=feminine Number=singular Case=accusative Animate=no",
			"Ncfsay", "noun", "Noun Type=common Gender=feminine Number=singular Case=accusative Animate=yes",
			"Ncfsvy", "noun", "Noun Type=common Gender=feminine Number=singular Case=vocative Animate=yes",
			"Ncfsln", "noun", "Noun Type=common Gender=feminine Number=singular Case=locative Animate=no",
			"Ncfsly", "noun", "Noun Type=common Gender=feminine Number=singular Case=locative Animate=yes",
			"Ncfsin", "noun", "Noun Type=common Gender=feminine Number=singular Case=instrumental Animate=no",
			"Ncfsiy", "noun", "Noun Type=common Gender=feminine Number=singular Case=instrumental Animate=yes",
			"Ncfpnn", "noun", "Noun Type=common Gender=feminine Number=plural Case=nominative Animate=no",
			"Ncfpny", "noun", "Noun Type=common Gender=feminine Number=plural Case=nominative Animate=yes",
			"Ncfpgn", "noun", "Noun Type=common Gender=feminine Number=plural Case=genitive Animate=no",
			"Ncfpgy", "noun", "Noun Type=common Gender=feminine Number=plural Case=genitive Animate=yes",
			"Ncfpdn", "noun", "Noun Type=common Gender=feminine Number=plural Case=dative Animate=no",
			"Ncfpdy", "noun", "Noun Type=common Gender=feminine Number=plural Case=dative Animate=yes",
			"Ncfpan", "noun", "Noun Type=common Gender=feminine Number=plural Case=accusative Animate=no",
			"Ncfpay", "noun", "Noun Type=common Gender=feminine Number=plural Case=accusative Animate=yes",
			"Ncfpln", "noun", "Noun Type=common Gender=feminine Number=plural Case=locative Animate=no",
			"Ncfply", "noun", "Noun Type=common Gender=feminine Number=plural Case=locative Animate=yes",
			"Ncfpin", "noun", "Noun Type=common Gender=feminine Number=plural Case=instrumental Animate=no",
			"Ncfpiy", "noun", "Noun Type=common Gender=feminine Number=plural Case=instrumental Animate=yes",
			"Ncnsnn", "noun", "Noun Type=common Gender=neuter Number=singular Case=nominative Animate=no",
			"Ncnsny", "noun", "Noun Type=common Gender=neuter Number=singular Case=nominative Animate=yes",
			"Ncnsgn", "noun", "Noun Type=common Gender=neuter Number=singular Case=genitive Animate=no",
			"Ncnsgy", "noun", "Noun Type=common Gender=neuter Number=singular Case=genitive Animate=yes",
			"Ncnsdn", "noun", "Noun Type=common Gender=neuter Number=singular Case=dative Animate=no",
			"Ncnsdy", "noun", "Noun Type=common Gender=neuter Number=singular Case=dative Animate=yes",
			"Ncnsan", "noun", "Noun Type=common Gender=neuter Number=singular Case=accusative Animate=no",
			"Ncnsay", "noun", "Noun Type=common Gender=neuter Number=singular Case=accusative Animate=yes",
			"Ncnsln", "noun", "Noun Type=common Gender=neuter Number=singular Case=locative Animate=no",
			"Ncnsly", "noun", "Noun Type=common Gender=neuter Number=singular Case=locative Animate=yes",
			"Ncnsin", "noun", "Noun Type=common Gender=neuter Number=singular Case=instrumental Animate=no",
			"Ncnsiy", "noun", "Noun Type=common Gender=neuter Number=singular Case=instrumental Animate=yes",
			"Ncnpnn", "noun", "Noun Type=common Gender=neuter Number=plural Case=nominative Animate=no",
			"Ncnpny", "noun", "Noun Type=common Gender=neuter Number=plural Case=nominative Animate=yes",
			"Ncnpgn", "noun", "Noun Type=common Gender=neuter Number=plural Case=genitive Animate=no",
			"Ncnpgy", "noun", "Noun Type=common Gender=neuter Number=plural Case=genitive Animate=yes",
			"Ncnpdn", "noun", "Noun Type=common Gender=neuter Number=plural Case=dative Animate=no",
			"Ncnpdy", "noun", "Noun Type=common Gender=neuter Number=plural Case=dative Animate=yes",
			"Ncnpan", "noun", "Noun Type=common Gender=neuter Number=plural Case=accusative Animate=no",
			"Ncnpay", "noun", "Noun Type=common Gender=neuter Number=plural Case=accusative Animate=yes",
			"Ncnpln", "noun", "Noun Type=common Gender=neuter Number=plural Case=locative Animate=no",
			"Ncnply", "noun", "Noun Type=common Gender=neuter Number=plural Case=locative Animate=yes",
			"Ncnpin", "noun", "Noun Type=common Gender=neuter Number=plural Case=instrumental Animate=no",
			"Ncnpiy", "noun", "Noun Type=common Gender=neuter Number=plural Case=instrumental Animate=yes",
			"Nccsny", "noun", "Noun Type=common Gender=common Number=singular Case=nominative Animate=yes",
			"Nccsgy", "noun", "Noun Type=common Gender=common Number=singular Case=genitive Animate=yes",
			"Nccsdy", "noun", "Noun Type=common Gender=common Number=singular Case=dative Animate=yes",
			"Nccsay", "noun", "Noun Type=common Gender=common Number=singular Case=accusative Animate=yes",
			"Nccsiy", "noun", "Noun Type=common Gender=common Number=singular Case=instrumental Animate=yes",
			"Nccpny", "noun", "Noun Type=common Gender=common Number=plural Case=nominative Animate=yes",
			"Nccpgy", "noun", "Noun Type=common Gender=common Number=plural Case=genitive Animate=yes",
			"Nccpdy", "noun", "Noun Type=common Gender=common Number=plural Case=dative Animate=yes",
			"Nccpay", "noun", "Noun Type=common Gender=common Number=plural Case=accusative Animate=yes",
			"Nccply", "noun", "Noun Type=common Gender=common Number=plural Case=locative Animate=yes",
			"Nccpiy", "noun", "Noun Type=common Gender=common Number=plural Case=instrumental Animate=yes",
			"Npmsmy", "name", "Noun Type=proper Gender=masculine Number=singular Case=*m Animate=yes",
			"Npmsnn", "name", "Noun Type=proper Gender=masculine Number=singular Case=nominative Animate=no",
			"Npmsny", "name", "Noun Type=proper Gender=masculine Number=singular Case=nominative Animate=yes",
			"Npmsgy", "name", "Noun Type=proper Gender=masculine Number=singular Case=genitive Animate=yes",
			"Npmsdy", "name", "Noun Type=proper Gender=masculine Number=singular Case=dative Animate=yes",
			"Npmsan", "name", "Noun Type=proper Gender=masculine Number=singular Case=accusative Animate=no",
			"Npmsay", "name", "Noun Type=proper Gender=masculine Number=singular Case=accusative Animate=yes",
			"Npmsly", "name", "Noun Type=proper Gender=masculine Number=singular Case=locative Animate=yes",
			"Npmsiy", "name", "Noun Type=proper Gender=masculine Number=singular Case=instrumental Animate=yes",
			"Npmpny", "name", "Noun Type=proper Gender=masculine Number=plural Case=nominative Animate=yes",
			"Npmpgy", "name", "Noun Type=proper Gender=masculine Number=plural Case=genitive Animate=yes",
			"Npmpdy", "name", "Noun Type=proper Gender=masculine Number=plural Case=dative Animate=yes",
			"Npmpay", "name", "Noun Type=proper Gender=masculine Number=plural Case=accusative Animate=yes",
			"Npmply", "name", "Noun Type=proper Gender=masculine Number=plural Case=locative Animate=yes",
			"Npmpiy", "name", "Noun Type=proper Gender=masculine Number=plural Case=instrumental Animate=yes",
			"Npfsny", "name", "Noun Type=proper Gender=feminine Number=singular Case=nominative Animate=yes",
			"Npfsgy", "name", "Noun Type=proper Gender=feminine Number=singular Case=genitive Animate=yes",
			"Npfsdy", "name", "Noun Type=proper Gender=feminine Number=singular Case=dative Animate=yes",
			"Npfsay", "name", "Noun Type=proper Gender=feminine Number=singular Case=accusative Animate=yes",
			"Npfsln", "name", "Noun Type=proper Gender=feminine Number=singular Case=locative Animate=no",
			"Npfsly", "name", "Noun Type=proper Gender=feminine Number=singular Case=locative Animate=yes",
			"Npfsiy", "name", "Noun Type=proper Gender=feminine Number=singular Case=instrumental Animate=yes",
			"Npfpgy", "name", "Noun Type=proper Gender=feminine Number=plural Case=genitive Animate=yes",
			"Npfpdy", "name", "Noun Type=proper Gender=feminine Number=plural Case=dative Animate=yes",
			"Npfpay", "name", "Noun Type=proper Gender=feminine Number=plural Case=accusative Animate=yes",
			"Npfpiy", "name", "Noun Type=proper Gender=feminine Number=plural Case=instrumental Animate=yes",
			"Npcsny", "name", "Noun Type=proper Gender=common Number=singular Case=nominative Animate=yes",
			"Npcsgy", "name", "Noun Type=proper Gender=common Number=singular Case=genitive Animate=yes",
			"Npcsdy", "name", "Noun Type=proper Gender=common Number=singular Case=dative Animate=yes",
			"Npcsay", "name", "Noun Type=proper Gender=common Number=singular Case=accusative Animate=yes",
			"Npcsly", "name", "Noun Type=proper Gender=common Number=singular Case=locative Animate=yes",
			"Npcsiy", "name", "Noun Type=proper Gender=common Number=singular Case=instrumental Animate=yes",
			"Npcpny", "name", "Noun Type=proper Gender=common Number=plural Case=nominative Animate=yes",
			"Npcpgy", "name", "Noun Type=proper Gender=common Number=plural Case=genitive Animate=yes",
			"Npcpay", "name", "Noun Type=proper Gender=common Number=plural Case=accusative Animate=yes",
			"Npcpiy", "name", "Noun Type=proper Gender=common Number=plural Case=instrumental Animate=yes",
			"P", "pronoun", "Pronoun",
			"P----g", "pronoun", "Pronoun Case=genitive",
			"P----d", "pronoun", "Pronoun Case=dative",
			"P----a", "pronoun", "Pronoun Case=accusative",
			"P----l", "pronoun", "Pronoun Case=locative",
			"P----i", "pronoun", "Pronoun Case=instrumental",
			"P---sg", "pronoun", "Pronoun Number=singular Case=genitive",
			"P---pn", "pronoun", "Pronoun Number=plural Case=nominative",
			"P---pn-y", "pronoun", "Pronoun Number=plural Case=nominative Animate=yes",
			"P---pg", "pronoun", "Pronoun Number=plural Case=genitive",
			"P---pd", "pronoun", "Pronoun Number=plural Case=dative",
			"P---pa", "pronoun", "Pronoun Number=plural Case=accusative",
			"P---pl", "pronoun", "Pronoun Number=plural Case=locative",
			"P---pi", "pronoun", "Pronoun Number=plural Case=instrumental",
			"P--msn", "pronoun", "Pronoun Gender=masculine Number=singular Case=nominative",
			"P--msn-y", "pronoun", "Pronoun Gender=masculine Number=singular Case=nominative Animate=yes",
			"P--msg", "pronoun", "Pronoun Gender=masculine Number=singular Case=genitive",
			"P--msd", "pronoun", "Pronoun Gender=masculine Number=singular Case=dative",
			"P--msa", "pronoun", "Pronoun Gender=masculine Number=singular Case=accusative",
			"P--msl", "pronoun", "Pronoun Gender=masculine Number=singular Case=locative",
			"P--msi", "pronoun", "Pronoun Gender=masculine Number=singular Case=instrumental",
			"P--msi-y", "pronoun", "Pronoun Gender=masculine Number=singular Case=instrumental Animate=yes",
			"P--fsn", "pronoun", "Pronoun Gender=feminine Number=singular Case=nominative",
			"P--fsg", "pronoun", "Pronoun Gender=feminine Number=singular Case=genitive",
			"P--fsd", "pronoun", "Pronoun Gender=feminine Number=singular Case=dative",
			"P--fsa", "pronoun", "Pronoun Gender=feminine Number=singular Case=accusative",
			"P--fsl", "pronoun", "Pronoun Gender=feminine Number=singular Case=locative",
			"P--fsi", "pronoun", "Pronoun Gender=feminine Number=singular Case=instrumental",
			"P--nsn", "pronoun", "Pronoun Gender=neuter Number=singular Case=nominative",
			"P--nsg", "pronoun", "Pronoun Gender=neuter Number=singular Case=genitive",
			"P--nsd", "pronoun", "Pronoun Gender=neuter Number=singular Case=dative",
			"P--nsd-n", "pronoun", "Pronoun Gender=neuter Number=singular Case=dative Animate=no",
			"P--nsa", "pronoun", "Pronoun Gender=neuter Number=singular Case=accusative",
			"P--nsl", "pronoun", "Pronoun Gender=neuter Number=singular Case=locative",
			"P--nsl-n", "pronoun", "Pronoun Gender=neuter Number=singular Case=locative Animate=no",
			"P--nsi", "pronoun", "Pronoun Gender=neuter Number=singular Case=instrumental",
			"P--nsi-n", "pronoun", "Pronoun Gender=neuter Number=singular Case=instrumental Animate=no",
			"P-1-sn", "pronoun", "Pronoun Person=first Number=singular Case=nominative",
			"P-1-sg", "pronoun", "Pronoun Person=first Number=singular Case=genitive",
			"P-1-sd", "pronoun", "Pronoun Person=first Number=singular Case=dative",
			"P-1-sa", "pronoun", "Pronoun Person=first Number=singular Case=accusative",
			"P-1-sl", "pronoun", "Pronoun Person=first Number=singular Case=locative",
			"P-1-si", "pronoun", "Pronoun Person=first Number=singular Case=instrumental",
			"P-1-pn", "pronoun", "Pronoun Person=first Number=plural Case=nominative",
			"P-1-pg", "pronoun", "Pronoun Person=first Number=plural Case=genitive",
			"P-1-pd", "pronoun", "Pronoun Person=first Number=plural Case=dative",
			"P-1-pa", "pronoun", "Pronoun Person=first Number=plural Case=accusative",
			"P-1-pl", "pronoun", "Pronoun Person=first Number=plural Case=locative",
			"P-1-pi", "pronoun", "Pronoun Person=first Number=plural Case=instrumental",
			"P-2-sn", "pronoun", "Pronoun Person=second Number=singular Case=nominative",
			"P-2-sg", "pronoun", "Pronoun Person=second Number=singular Case=genitive",
			"P-2-sd", "pronoun", "Pronoun Person=second Number=singular Case=dative",
			"P-2-sa", "pronoun", "Pronoun Person=second Number=singular Case=accusative",
			"P-2-sl", "pronoun", "Pronoun Person=second Number=singular Case=locative",
			"P-2-si", "pronoun", "Pronoun Person=second Number=singular Case=instrumental",
			"P-2-pn", "pronoun", "Pronoun Person=second Number=plural Case=nominative",
			"P-2-pg", "pronoun", "Pronoun Person=second Number=plural Case=genitive",
			"P-2-pd", "pronoun", "Pronoun Person=second Number=plural Case=dative",
			"P-2-pa", "pronoun", "Pronoun Person=second Number=plural Case=accusative",
			"P-2-pl", "pronoun", "Pronoun Person=second Number=plural Case=locative",
			"P-2-pi", "pronoun", "Pronoun Person=second Number=plural Case=instrumental",
			"P-3-pn", "pronoun", "Pronoun Person=third Number=plural Case=nominative",
			"P-3-pg", "pronoun", "Pronoun Person=third Number=plural Case=genitive",
			"P-3-pd", "pronoun", "Pronoun Person=third Number=plural Case=dative",
			"P-3-pa", "pronoun", "Pronoun Person=third Number=plural Case=accusative",
			"P-3-pl", "pronoun", "Pronoun Person=third Number=plural Case=locative",
			"P-3-pi", "pronoun", "Pronoun Person=third Number=plural Case=instrumental",
			"P-3msn", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=nominative",
			"P-3msg", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=genitive",
			"P-3msd", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=dative",
			"P-3msa", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=accusative",
			"P-3msl", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=locative",
			"P-3msi", "pronoun", "Pronoun Person=third Gender=masculine Number=singular Case=instrumental",
			"P-3fsn", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=nominative",
			"P-3fsg", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=genitive",
			"P-3fsd", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=dative",
			"P-3fsa", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=accusative",
			"P-3fsl", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=locative",
			"P-3fsi", "pronoun", "Pronoun Person=third Gender=feminine Number=singular Case=instrumental",
			"P-3nsn", "pronoun", "Pronoun Person=third Gender=neuter Number=singular Case=nominative",
			"P-3nsl", "pronoun", "Pronoun Person=third Gender=neuter Number=singular Case=locative",
			"Q", "particle", "Particle",
			"R", "adverb", "Adverb",
			"Sc", "adposition", "Adposition Type=*c",
			"Sp-n", "preposition", "Adposition Type=preposition Case=*n",
			"Sp-g", "preposition", "Adposition Type=preposition Case=genitive",
			"Sp-d", "preposition", "Adposition Type=preposition Case=dative",
			"Sp-a", "preposition", "Adposition Type=preposition Case=accusative",
			"Sp-l", "preposition", "Adposition Type=preposition Case=locative",
			"Sp-i", "preposition", "Adposition Type=preposition Case=instrumental",
			"Vm", "verb", "Verb Type=main",
			"Vm--------d", "verb", "Verb Type=main Case=dative",
			"Vm------f", "verb", "Verb Type=main Definiteness=full-art",
			"Vm-----mf", "verb", "Verb Type=main Voice=medial Definiteness=full-art",
			"Vm---sn---d", "verb", "Verb Type=main Number=singular Gender=neuter Case=dative",
			"Vm--1p---p", "verb", "Verb Type=main Person=first Number=plural Aspect=progressive",
			"Vm-p-smafpn", "verb", "Verb Type=main Tense=present Number=singular Gender=masculine Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-smpfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=masculine Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-smmfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=masculine Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-sfafpn", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-sfafpa", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-p-sfpsp", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-p-sfpfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-sfpfpa", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-p-sfmfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-sfmfpa", "verb", "Verb Type=main Tense=present Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-p-snafpn", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-snafpg", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-p-snafpd", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=dative",
			"Vm-p-snpsp", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-p-snpfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-snpfpg", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-p-snpfpd", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=dative",
			"Vm-p-snmfpn", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-snmfpg", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-p-snmfpd", "verb", "Verb Type=main Tense=present Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=dative",
			"Vm-p-p-afpn", "verb", "Verb Type=main Tense=present Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-p-afpi", "verb", "Verb Type=main Tense=present Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p-p-psp", "verb", "Verb Type=main Tense=present Number=plural Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-p-p-pfpn", "verb", "Verb Type=main Tense=present Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-p-pfpi", "verb", "Verb Type=main Tense=present Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p-p-mfpn", "verb", "Verb Type=main Tense=present Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-p-p-mfpi", "verb", "Verb Type=main Tense=present Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p-pnafpi", "verb", "Verb Type=main Tense=present Number=plural Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p-pnpfpi", "verb", "Verb Type=main Tense=present Number=plural Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p-pnmfpi", "verb", "Verb Type=main Tense=present Number=plural Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-p1s-a-p", "verb", "Verb Type=main Tense=present Person=first Number=singular Voice=active Aspect=progressive",
			"Vm-p1p-a-p", "verb", "Verb Type=main Tense=present Person=first Number=plural Voice=active Aspect=progressive",
			"Vm-p2s-a-p", "verb", "Verb Type=main Tense=present Person=second Number=singular Voice=active Aspect=progressive",
			"Vm-p2p-a-p", "verb", "Verb Type=main Tense=present Person=second Number=plural Voice=active Aspect=progressive",
			"Vm-p3s-a-p", "verb", "Verb Type=main Tense=present Person=third Number=singular Voice=active Aspect=progressive",
			"Vm-p3s-m-p", "verb", "Verb Type=main Tense=present Person=third Number=singular Voice=medial Aspect=progressive",
			"Vm-p3p-a-p", "verb", "Verb Type=main Tense=present Person=third Number=plural Voice=active Aspect=progressive",
			"Vm-f1s-a-e", "verb", "Verb Type=main Tense=future Person=first Number=singular Voice=active Aspect=perfective",
			"Vm-f1p-a-e", "verb", "Verb Type=main Tense=future Person=first Number=plural Voice=active Aspect=perfective",
			"Vm-f2s-a-e", "verb", "Verb Type=main Tense=future Person=second Number=singular Voice=active Aspect=perfective",
			"Vm-f2s-m-e", "verb", "Verb Type=main Tense=future Person=second Number=singular Voice=medial Aspect=perfective",
			"Vm-f2p-a-e", "verb", "Verb Type=main Tense=future Person=second Number=plural Voice=active Aspect=perfective",
			"Vm-f3s-a-e", "verb", "Verb Type=main Tense=future Person=third Number=singular Voice=active Aspect=perfective",
			"Vm-f3p-a-e", "verb", "Verb Type=main Tense=future Person=third Number=plural Voice=active Aspect=perfective",
			"Vm-s-sma-p", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Aspect=progressive",
			"Vm-s-sma-e", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Aspect=perfective",
			"Vm-s-smafp", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Definiteness=full-art Aspect=progressive",
			"Vm-s-smafpn", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-smafe", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Definiteness=full-art Aspect=perfective",
			"Vm-s-smafen", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=active Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-smpsp", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-s-smpse", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=passive Definiteness=short-art Aspect=perfective",
			"Vm-s-smpfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-smpfen", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=passive Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-smmfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-smmfen", "verb", "Verb Type=main Tense=past Number=singular Gender=masculine Voice=medial Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-sfa-p", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Aspect=progressive",
			"Vm-s-sfa-e", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Aspect=perfective",
			"Vm-s-sfafpn", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-sfafpa", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-s-sfafe", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=perfective",
			"Vm-s-sfafen", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-sfafea", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=perfective Case=accusative",
			"Vm-s-sfpsp", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-s-sfpse", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=short-art Aspect=perfective",
			"Vm-s-sfpfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-sfpfpa", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-s-sfpfen", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-sfpfea", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=perfective Case=accusative",
			"Vm-s-sfmfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-sfmfpa", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=accusative",
			"Vm-s-sfmfen", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-sfmfea", "verb", "Verb Type=main Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=perfective Case=accusative",
			"Vm-s-sna-p", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Aspect=progressive",
			"Vm-s-sna-e", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Aspect=perfective",
			"Vm-s-snafpn", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-snafpg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-s-snafpd", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=dative",
			"Vm-s-snafen", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-snafeg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=perfective Case=genitive",
			"Vm-s-snafed", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=perfective Case=dative",
			"Vm-s-snpsp", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-s-snpse", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=short-art Aspect=perfective",
			"Vm-s-snpfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-snpfpg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-s-snpfpd", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=dative",
			"Vm-s-snpfen", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-snpfeg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=perfective Case=genitive",
			"Vm-s-snpfed", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=perfective Case=dative",
			"Vm-s-snmfpn", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-snmfpg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=genitive",
			"Vm-s-snmfen", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-snmfeg", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=perfective Case=genitive",
			"Vm-s-snmfed", "verb", "Verb Type=main Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=perfective Case=dative",
			"Vm-s-p-a-p", "verb", "Verb Type=main Tense=past Number=plural Voice=active Aspect=progressive",
			"Vm-s-p-a-e", "verb", "Verb Type=main Tense=past Number=plural Voice=active Aspect=perfective",
			"Vm-s-p-afp", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=progressive",
			"Vm-s-p-afpn", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-p-afpi", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-s-p-afe", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=perfective",
			"Vm-s-p-afen", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-p-afei", "verb", "Verb Type=main Tense=past Number=plural Voice=active Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vm-s-p-psp", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=short-art Aspect=progressive",
			"Vm-s-p-pse", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=short-art Aspect=perfective",
			"Vm-s-p-pfpn", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-p-pfpi", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-s-p-pfen", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-p-pfei", "verb", "Verb Type=main Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vm-s-p-m-e", "verb", "Verb Type=main Tense=past Number=plural Voice=medial Aspect=perfective",
			"Vm-s-p-mfpn", "verb", "Verb Type=main Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=nominative",
			"Vm-s-p-mfpi", "verb", "Verb Type=main Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-s-p-mfen", "verb", "Verb Type=main Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=perfective Case=nominative",
			"Vm-s-p-mfei", "verb", "Verb Type=main Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vm-s-pnafpi", "verb", "Verb Type=main Tense=past Number=plural Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-s-pnafei", "verb", "Verb Type=main Tense=past Number=plural Gender=neuter Voice=active Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vm-s-pnpfpi", "verb", "Verb Type=main Tense=past Number=plural Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vm-s-pnpfei", "verb", "Verb Type=main Tense=past Number=plural Gender=neuter Voice=passive Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vm-s-pnmfei", "verb", "Verb Type=main Tense=past Number=plural Gender=neuter Voice=medial Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vmi", "verb", "Verb Type=main VForm=indicative",
			"Vmi----m", "verb", "Verb Type=main VForm=indicative Voice=medial",
			"Vmi--sna-p", "verb", "Verb Type=main VForm=indicative Number=singular Gender=neuter Voice=active Aspect=progressive",
			"Vmi--sna-e", "verb", "Verb Type=main VForm=indicative Number=singular Gender=neuter Voice=active Aspect=perfective",
			"Vmi--snm-p", "verb", "Verb Type=main VForm=indicative Number=singular Gender=neuter Voice=medial Aspect=progressive",
			"Vmi--snm-e", "verb", "Verb Type=main VForm=indicative Number=singular Gender=neuter Voice=medial Aspect=perfective",
			"Vmi-1s-a-p", "verb", "Verb Type=main VForm=indicative Person=first Number=singular Voice=active Aspect=progressive",
			"Vmi-1s-a-e", "verb", "Verb Type=main VForm=indicative Person=first Number=singular Voice=active Aspect=perfective",
			"Vmi-1s-m-e", "verb", "Verb Type=main VForm=indicative Person=first Number=singular Voice=medial Aspect=perfective",
			"Vmi-1p-a-p", "verb", "Verb Type=main VForm=indicative Person=first Number=plural Voice=active Aspect=progressive",
			"Vmi-1p-a-e", "verb", "Verb Type=main VForm=indicative Person=first Number=plural Voice=active Aspect=perfective",
			"Vmi-1p-m-e", "verb", "Verb Type=main VForm=indicative Person=first Number=plural Voice=medial Aspect=perfective",
			"Vmi-2p-a-p", "verb", "Verb Type=main VForm=indicative Person=second Number=plural Voice=active Aspect=progressive",
			"Vmi-2p-a-e", "verb", "Verb Type=main VForm=indicative Person=second Number=plural Voice=active Aspect=perfective",
			"Vmi-2p-m-p", "verb", "Verb Type=main VForm=indicative Person=second Number=plural Voice=medial Aspect=progressive",
			"Vmi-2p-m-e", "verb", "Verb Type=main VForm=indicative Person=second Number=plural Voice=medial Aspect=perfective",
			"Vmip1s-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=first Number=singular Voice=active Aspect=progressive",
			"Vmip1s-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=first Number=singular Voice=medial Aspect=progressive",
			"Vmip1p-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=first Number=plural Voice=active Aspect=progressive ",
			"Vmip1p-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=first Number=plural Voice=medial Aspect=progressive",
			"Vmip1pmpsp", "verb", "Verb Type=main VForm=indicative Tense=present Person=first Number=plural Gender=masculine Voice=passive Definiteness=short-art Aspect=progressive",
			"Vmip2s-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=second Number=singular Voice=active Aspect=progressive",
			"Vmip2s-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=second Number=singular Voice=medial Aspect=progressive",
			"Vmip2p-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=second Number=plural Voice=active Aspect=progressive",
			"Vmip2p-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=second Number=plural Voice=medial Aspect=progressive",
			"Vmip3s-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=third Number=singular Voice=active Aspect=progressive",
			"Vmip3s-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=third Number=singular Voice=medial Aspect=progressive",
			"Vmip3p-a-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=third Number=plural Voice=active Aspect=progressive",
			"Vmip3p-m-p", "verb", "Verb Type=main VForm=indicative Tense=present Person=third Number=plural Voice=medial Aspect=progressive",
			"Vmif1s-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=singular Voice=active Aspect=progressive",
			"Vmif1s-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=singular Voice=active Aspect=perfective",
			"Vmif1s-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=singular Voice=medial Aspect=perfective",
			"Vmif1p-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=plural Voice=active Aspect=progressive",
			"Vmif1p-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=plural Voice=active Aspect=perfective",
			"Vmif1p-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=first Number=plural Voice=medial Aspect=perfective",
			"Vmif2s-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=singular Voice=active Aspect=progressive",
			"Vmif2s-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=singular Voice=active Aspect=perfective",
			"Vmif2s-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=singular Voice=medial Aspect=perfective",
			"Vmif2p-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=plural Voice=active Aspect=progressive",
			"Vmif2p-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=plural Voice=active Aspect=perfective",
			"Vmif2p-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=second Number=plural Voice=medial Aspect=perfective",
			"Vmif3s-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=singular Voice=active Aspect=progressive",
			"Vmif3s-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=singular Voice=active Aspect=perfective",
			"Vmif3s-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=singular Voice=medial Aspect=perfective",
			"Vmif3p-a-p", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=plural Voice=active Aspect=progressive",
			"Vmif3p-a-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=plural Voice=active Aspect=perfective",
			"Vmif3p-m-e", "verb", "Verb Type=main VForm=indicative Tense=future Person=third Number=plural Voice=medial Aspect=perfective",
			"Vmis-sma-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=masculine Voice=active Aspect=progressive",
			"Vmis-sma-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=masculine Voice=active Aspect=perfective",
			"Vmis-smm-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=masculine Voice=medial Aspect=progressive",
			"Vmis-smm-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=masculine Voice=medial Aspect=perfective",
			"Vmis-sfa-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=feminine Voice=active Aspect=progressive",
			"Vmis-sfa-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=feminine Voice=active Aspect=perfective",
			"Vmis-sfm-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=feminine Voice=medial Aspect=progressive",
			"Vmis-sfm-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=feminine Voice=medial Aspect=perfective",
			"Vmis-sna-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=neuter Voice=active Aspect=progressive",
			"Vmis-sna-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=neuter Voice=active Aspect=perfective",
			"Vmis-snm-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=neuter Voice=medial Aspect=progressive",
			"Vmis-snm-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=singular Gender=neuter Voice=medial Aspect=perfective",
			"Vmis-p-a-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=plural Voice=active Aspect=progressive",
			"Vmis-p-a-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=plural Voice=active Aspect=perfective",
			"Vmis-p-m-p", "verb", "Verb Type=main VForm=indicative Tense=past Number=plural Voice=medial Aspect=progressive",
			"Vmis-p-m-e", "verb", "Verb Type=main VForm=indicative Tense=past Number=plural Voice=medial Aspect=perfective",
			"Vmis3pmpse", "verb", "Verb Type=main VForm=indicative Tense=past Person=third Number=plural Gender=masculine Voice=passive Definiteness=short-art Aspect=perfective",
			"Vmm-1p-a-p", "verb", "Verb Type=main VForm=imperative Person=first Number=plural Voice=active Aspect=progressive",
			"Vmm-1p-a-e", "verb", "Verb Type=main VForm=imperative Person=first Number=plural Voice=active Aspect=perfective",
			"Vmm-2s-a-p", "verb", "Verb Type=main VForm=imperative Person=second Number=singular Voice=active Aspect=progressive",
			"Vmm-2s-a-e", "verb", "Verb Type=main VForm=imperative Person=second Number=singular Voice=active Aspect=perfective",
			"Vmm-2s-m-p", "verb", "Verb Type=main VForm=imperative Person=second Number=singular Voice=medial Aspect=progressive",
			"Vmm-2s-m-e", "verb", "Verb Type=main VForm=imperative Person=second Number=singular Voice=medial Aspect=perfective",
			"Vmm-2p-a-p", "verb", "Verb Type=main VForm=imperative Person=second Number=plural Voice=active Aspect=progressive",
			"Vmm-2p-a-e", "verb", "Verb Type=main VForm=imperative Person=second Number=plural Voice=active Aspect=perfective",
			"Vmm-2p-m-p", "verb", "Verb Type=main VForm=imperative Person=second Number=plural Voice=medial Aspect=progressive",
			"Vmm-2p-m-e", "verb", "Verb Type=main VForm=imperative Person=second Number=plural Voice=medial Aspect=perfective",
			"Vmn----a-p", "verb", "Verb Type=main VForm=infinitive Voice=active Aspect=progressive",
			"Vmn----a-e", "verb", "Verb Type=main VForm=infinitive Voice=active Aspect=perfective",
			"Vmn----m-p", "verb", "Verb Type=main VForm=infinitive Voice=medial Aspect=progressive",
			"Vmn----m-e", "verb", "Verb Type=main VForm=infinitive Voice=medial Aspect=perfective",
			"Vmpp-sfafpn", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=nominative",
			"Vmpp-sfafpa", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=accusative",
			"Vmpp-sfafpi", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmpp-sfpfpn", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=nominative",
			"Vmpp-sfpfpi", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmpp-sfmfpi", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmpp-snafpl", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=locative",
			"Vmpp-snpsp", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=neuter Voice=passive Definiteness=short-art Aspect=progressive",
			"Vmpp-snpfpl", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=locative",
			"Vmpp-snmfpl", "verb", "Verb Type=main VForm=participle Tense=present Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=locative",
			"Vmpp-p-afpg", "verb", "Verb Type=main VForm=participle Tense=present Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmpp-p-pfpg", "verb", "Verb Type=main VForm=participle Tense=present Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmpp-p-mfpg", "verb", "Verb Type=main VForm=participle Tense=present Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmps-smpse", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=masculine Voice=passive Definiteness=short-art Aspect=perfective",
			"Vmps-sfafpi", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmps-sfafei", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=active Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vmps-sfpse", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=passive Definiteness=short-art Aspect=perfective",
			"Vmps-sfpfpi", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmps-sfpfen", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=perfective Case=nominative",
			"Vmps-sfpfea", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=perfective Case=accusative",
			"Vmps-sfpfei", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=passive Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vmps-sfmfpi", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=progressive Case=instrumental",
			"Vmps-sfmfea", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=perfective Case=accusative",
			"Vmps-sfmfei", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=feminine Voice=medial Definiteness=full-art Aspect=perfective Case=instrumental",
			"Vmps-snafpl", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=progressive Case=locative",
			"Vmps-snafel", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=active Definiteness=full-art Aspect=perfective Case=locative",
			"Vmps-snpfpl", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=progressive Case=locative",
			"Vmps-snpfel", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=passive Definiteness=full-art Aspect=perfective Case=locative",
			"Vmps-snmfpl", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=progressive Case=locative",
			"Vmps-snmfel", "verb", "Verb Type=main VForm=participle Tense=past Number=singular Gender=neuter Voice=medial Definiteness=full-art Aspect=perfective Case=locative",
			"Vmps-p-afpg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=active Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmps-p-afeg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=active Definiteness=full-art Aspect=perfective Case=genitive",
			"Vmps-p-pfpg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmps-p-pfeg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=passive Definiteness=full-art Aspect=perfective Case=genitive",
			"Vmps-p-mfpg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=progressive Case=genitive",
			"Vmps-p-mfeg", "verb", "Verb Type=main VForm=participle Tense=past Number=plural Voice=medial Definiteness=full-art Aspect=perfective Case=genitive",
			"Vmg----a-p", "verb", "Verb Type=main VForm=gerund Voice=active Aspect=progressive",
			"Vmg----a-e", "verb", "Verb Type=main VForm=gerund Voice=active Aspect=perfective",
			"Vmg----m-p", "verb", "Verb Type=main VForm=gerund Voice=medial Aspect=progressive",
			"Vmg----m-e", "verb", "Verb Type=main VForm=gerund Voice=medial Aspect=perfective",
			"Vmgp---a-p", "verb", "Verb Type=main VForm=gerund Tense=present Voice=active Aspect=progressive",
			"Vmgp---m-p", "verb", "Verb Type=main VForm=gerund Tense=present Voice=medial Aspect=progressive",
			"Vmgf---a-e", "verb", "Verb Type=main VForm=gerund Tense=future Voice=active Aspect=perfective",
			"Vmgs---a-e", "verb", "Verb Type=main VForm=gerund Tense=past Voice=active Aspect=perfective",
			"Vmgs---m-e", "verb", "Verb Type=main VForm=gerund Tense=past Voice=medial Aspect=perfective",
			"X", "residual", "Residual",
			"Y", "abbreviation", "Abbreviation"
			), ncol=3, byrow=TRUE, dimnames=list(c(),c("tag","wclass","desc"))),
		tag.class.def.punct=matrix(c(
			",", "comma", "Comma", # not in guidelines
			"-", "punctuation", "Punctuation" # not in guidelines
			), ncol=3, byrow=TRUE, dimnames=list(c(),c("tag","wclass","desc"))),
		tag.class.def.sentc=matrix(c(
			"SENT", "fullstop", "Sentence ending punctuation" # not in guidelines
			), ncol=3, byrow=TRUE, dimnames=list(c(),c("tag","wclass","desc")))
		)
	)
)