% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_01_kRp.tagged.R
\docType{class}
\name{kRp.tagged,-class}
\alias{kRp.tagged,-class}
\alias{kRp_tagged}
\alias{kRp.tagged-class}
\title{S4 Class kRp.tagged}
\description{
This class is used for objects that are returned by \code{\link[koRpus:treetag]{treetag}} or \code{\link[koRpus:tokenize]{tokenize}}.
}
\section{Slots}{

\describe{
\item{\code{lang}}{A character string,
      naming the language that is assumed for the tokenized text in this object.}

\item{\code{desc}}{Descriptive statistics of the tagged text.}

\item{\code{TT.res}}{Results of the called tokenizer and POS tagger. The data.frame has eight columns:
\describe{
  \item{\code{doc_id}:}{Optional document identifier.}
  \item{\code{token}:}{The tokenized text.}
  \item{\code{tag}:}{POS tags for each token.}
  \item{\code{lemma}:}{Lemma for each token.}
  \item{\code{lttr}:}{Number of letters.}
  \item{\code{wclass}:}{Word class.}
  \item{\code{desc}:}{A short description of the POS tag.}
  \item{\code{stop}:}{Logical, \code{TRUE} if token is a stopword.}
  \item{\code{stem}:}{Stemmed token.}
  \item{\code{idx}:}{Index number of token in this document.}
  \item{\code{sntc}:}{Number of sentence in this document.}
}
This data.frame structure adheres to the "Text Interchange Formats" guidelines set out by rOpenSci[1].}
}}

\note{
There is also \code{as()} methods to transform objects from other koRpus classes into kRp.tagged.
}
\section{Contructor function}{

Should you need to manually generate objects of this class (which should rarely be the case),
      the contructor function 
\code{kRp_tagged(...)} can be used instead of
\code{new("kRp.tagged", ...)}.
}

\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
\keyword{classes}
