% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_textTransform.R
\docType{methods}
\name{textTransform}
\alias{textTransform}
\alias{textTransform,kRp.text-method}
\title{Letter case transformation}
\usage{
textTransform(txt, ...)

\S4method{textTransform}{kRp.text}(
  txt,
  scheme,
  p = 0.5,
  paste = FALSE,
  var = "wclass",
  query = "fullstop",
  method = "replace",
  replacement = ".",
  f = NA,
  ...
)
}
\arguments{
\item{txt}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Parameters passed to \code{\link[koRpus:query]{query}} to find matching tokens. Relevant only if \code{scheme="normalize"}.}

\item{scheme}{One of the following character strings:
\itemize{
  \item {\code{"minor"}} {Start each word with a lowercase letter.}
  \item {\code{"all.minor"}} {Forces all letters into lowercase.}
  \item {\code{"major"}} {Start each word with a uppercase letter.}
  \item {\code{"all.major"}} {Forces all letters into uppercase.}
  \item {\code{"random"}} {Randomly start words with uppercase or lowercase letters.}
  \item {\code{"de.norm"}} {German norm: All names,
      nouns and sentence beginnings start with an uppercase letter,
     anything else with a lowercase letter.}
  \item {\code{"de.inv"}} {Inversion of \code{"de.norm"}.}
  \item {\code{"eu.norm"}} {Usual European cases: Only names and sentence beginnings start with an uppercase letter,
     anything else with a lowercase letter.}
  \item {\code{"eu.inv"}} {Inversion of \code{"eu.norm"}.}
  \item {\code{"normalize"}} {Replace all tokens matching \code{query} in column \code{var} according to \code{method} (see below).}
 }}

\item{p}{Numeric value between 0 and 1. Defines the probability for upper case letters (relevant only
if \code{scheme="random"}).}

\item{paste}{Logical, see value section.}

\item{var}{A character string naming a variable in the object (i.e.,
      colname). See \code{\link[koRpus:query]{query}} for details.
Relevant only if \code{scheme="normalize"}.}

\item{query}{A character vector (for words), regular expression,
      or single number naming values to be matched in the variable.
See \code{\link[koRpus:query]{query}} for details. Relevant only if \code{scheme="normalize"}.}

\item{method}{One of the following character strings:
\itemize{
  \item {\code{"shortest"}} {Replace all matches with the shortest value found.}
  \item {\code{"longest"}} {Replace all matches with the longest value found.}
  \item {\code{"replace"}} {Replace all matches with the token given via \code{replacement}.}
  \item {\code{"function"}} {Replace all matches with the result of the function provided by \code{f} (see section Function for details).}
}
In case of \code{"shortest"} and \code{"longest"},
      if multiple values of the same length are found, the (first) most prevalent one is being used.
The actual replacement value is documented in the \code{diff} slot of the object,
      as a list called \code{transfmt.normalize}.
Relevant only if \code{scheme="normalize"}.}

\item{replacement}{Character string defining the exact token to replace all query matches with.
Relevant only if \code{scheme="normalize"} and \code{method="replace"}.}

\item{f}{A function to calculate the replacement for all query matches.
Relevant only if \code{scheme="normalize"} and \code{method="function"}.}
}
\value{
By default an object of class \code{\link[koRpus:kRp.text-class]{kRp.text}} with the added feature \code{diff} is returned.
   It provides a list with mostly atomic vectors,
      describing the amount of diffences between both text variants (percentage):
   \describe{
     \item{\code{all.tokens}:}{Percentage of all tokens, including punctuation,
      that were altered.}
     \item{\code{words}:}{Percentage of altered words only.}
     \item{\code{all.chars}:}{Percentage of all characters, including punctuation,
      that were altered.}
     \item{\code{letters}:}{Percentage of altered letters in words only.}
     \item{\code{transfmt}:}{Character vector documenting the transformation(s) done to the tokens.}
     \item{\code{transfmt.equal}:}{Data frame documenting which token was changed in which transformational step. Only available if more than one transformation was done.}
     \item{\code{transfmt.normalize}:}{A list documenting steps of normalization that were done to the object,
      one element per transformation.
       Each entry holds the name of the method, the query parameters,
      and the effective replacement value.}
   }
   If \code{paste=TRUE},
      returns an atomic character vector (via \code{\link[koRpus:pasteText]{pasteText}}).
}
\description{
Transforms text in koRpus objects token by token.
}
\details{
This method is mainly intended to produce text material for experiments.
}
\section{Function}{
 You can dynamically calculate the replacement value for the \code{"normalize"} scheme by setting \code{method="function"} and
providing a function object as \code{f}. The function you provide must support the following arguments:
\itemize{
  \item {\code{tokens}} {The original tokens slot of the \code{txt} object (see \code{\link[koRpus:taggedText]{taggedText}}).}
  \item {\code{match}} {A logical vector,
      indicating for each row of \code{tokens} whether it's a query match or not.}
}
You can then use these arguments in your function body to calculate the replacement,
      e.g. \code{tokens[match,"token"]} to get all relevant tokens.
The return value of the function will be used as the replacement for all matched tokens. You probably want to make sure it's a character vecor
of length one or of the same length as all matches.
}

\examples{
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  sample_file <- file.path(
    path.package("koRpus"), "examples", "corpus", "Reality_Winner.txt"
  )
  tokenized.obj <- tokenize(
    txt=sample_file,
    lang="en"
  )
  tokenized.obj <- textTransform(
    tokenized.obj,
    scheme="random"
  )
  pasteText(tokenized.obj)

  # diff stats are now part of the object
  hasFeature(tokenized.obj)
  diffText(tokenized.obj)
} else {}
}
\keyword{misc}
