% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMinorAxisLength.R
\name{lakeMinorAxisLength}
\alias{lakeMinorAxisLength}
\title{Calculate the length of the minor axis for lake}
\usage{
lakeMinorAxisLength(inLakeMorpho, addLine = TRUE)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{addLine}{Boolean to determine if the selected minor axis line should be 
added to the inLakeMorpho object.  Defaults to True}
}
\value{
This returns a numeric value indicating the length of the minor axis
 in the lake. Units are the same as the input data.
}
\description{
Minor axis length is defined as the minimum length spanning the convex hull
of a lake.
}
\examples{
data(lakes)
lakeMinorAxisLength(inputLM)
plot(inputLM$lake)
lines(inputLM$minoraxisLengthLine)
}
\references{
\href{https://en.wikipedia.org/wiki/Semi-major_and_semi-minor_axes}{Wikipedia}
}

