% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{removeFromList}
\alias{removeFromList}
\title{Remove elements from a list file.}
\usage{
removeFromList(file, index)
}
\arguments{
\item{file}{Name of file.}

\item{index}{A numeric, logical or character vector.}
}
\value{
invisible \code{TRUE} if no error occurs.
}
\description{
Remove elements from a list file.
}
\details{
It removes elements with given indices or names. This function may relocate all the data 
in the stored file, thus can be very slow! Please consider to call this function 
batchwise instead of one index by one index.
}
\examples{
list1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))
saveList(list1, "example.llo")
removeFromList("example.llo", c("A"))
removeFromList("example.llo", c(2))
}
\seealso{
\code{\link{largeList}}
}

