% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lvm.R
\name{lvm}
\alias{lvm}
\alias{print.lvm}
\alias{summary.lvm}
\title{Initialize new latent variable model}
\usage{
lvm(x = NULL, ..., silent = lava.options()$silent)
}
\arguments{
\item{x}{Vector of variable names. Optional but gives control of the
sequence of appearance of the variables. The argument can be given as a
character vector or formula, e.g. \code{~y1+y2} is equivalent to
\code{c("y1","y2")}. Alternatively the argument can be a formula specifying
a linear model.}

\item{silent}{Logical variable which indicates whether messages are turned
on/off.}

\item{\dots}{Additional arguments to be passed to the low level functions}
}
\value{
Returns an object of class \code{lvm}.
}
\description{
Function that constructs a new latent variable model object
}
\examples{
m <- lvm() # Empty model
m1 <- lvm(y~x) # Simple linear regression
m2 <- lvm(~y1+y2) # Model with two independent variables (argument)
m3 <- lvm(list(c(y1,y2,y3)~u,u~x+z)) # SEM with three items
}
\author{
Klaus K. Holst
}
\seealso{
\code{\link{regression}}, \code{\link{covariance}},
\code{\link{intercept}}, ...
}
\keyword{models}
\keyword{regression}

