% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryplot.R
\name{summaryplot}
\alias{summaryplot}
\title{Summary of models}
\usage{
summaryplot(
  m1,
  ...,
  which = c("BIC", "entropy", "ICL"),
  mfrow = c(1, length(which)),
  xaxis = "G"
)
}
\arguments{
\item{m1}{an object of class \code{hlme}, \code{lcmm}, \code{multlcmm},
\code{Jointlcmm}, \code{mpjlcmm}, \code{externVar} or \code{externVar}.}

\item{\dots}{further arguments, in particular other objects of class
\code{hlme}, \code{lcmm}, \code{multlcmm}, \code{Jointlcmm} or \code{mpjlcmm}, and
graphical parameters.}

\item{which}{character vector indicating which results should be plotted.
Possible values are "loglik", "conv", "npm", "AIC", "BIC", "SABIC",
"entropy", "ICL", "ICL1", "ICL2".}

\item{mfrow}{for multiple plots, number of rows and columns to split the graphical device.
Default to one line and length(which) columns.}

\item{xaxis}{the abscissa of the plot. Default to "G", the number of latent classes.}
}
\description{
This function provides a plot summarizing the results of different models
fitted by \code{hlme}, \code{lcmm}, \code{multlcmm}, \code{Jointlcmm},
\code{mpjlcmm} or \code{externVar}.
}
\details{
Can be reported the usual criteria used to assess the fit and the clustering
 of the data:
 - maximum log-likelihood L (the higher the better)
 - number of parameters P, number of classes G, convergence criterion (1 = converged)
 - AIC (the lower the better) computed as -2L+2P 
 - BIC (the lower the better) computed as -2L+ P log(N) where N is the number of subjects
 - SABIC (the lower the better) computed as -2L+ P log((N+2)/24)
 - Entropy (the closer to one the better) computed as 1-sum[pi_ig*log(pi_ig)]/(N*log(G))
   where pi_ig is the posterior probability that subject i belongs to class g
 - ICL (the lower the better) computed in two ways : ICL1 = BIC - sum[pi_ig*log(pi_ig)]
   or ICL2 = BIC - 2*sum(log(max(pi_ig)), where the max is taken over the classes for each subject.
 - %Class computed as the proportion of each class based on c_ig
}
\examples{
\dontrun{
library(NormPsy)
paquid$normMMSE <- normMMSE(paquid$MMSE)
paquid$age65 <- (paquid$age - 65)/10
m1 <- hlme(normMMSE~age65+I(age65^2)+CEP, random=~age65+I(age65^2), subject='ID', data=paquid)
m2 <- hlme(normMMSE~age65+I(age65^2)+CEP, random=~age65+I(age65^2), subject='ID', data=paquid,
ng = 2, mixture=~age65+I(age65^2), B=m1)
m3g <- gridsearch(hlme(normMMSE~age65+I(age65^2)+CEP, random=~age65+I(age65^2), subject='ID',
data=paquid, ng=3, mixture=~age65+I(age65^2)), rep=100, maxiter=30, minit=m1)
summaryplot(m1, m2, m3g, which=c("BIC","entropy","ICL"),bty="l",pch=20,col=2)
}
}
\seealso{
\code{\link{summary}}, \code{\link{summarytable}}
}
\author{
Sasha Cuau, Viviane Philipps, Cecile Proust-Lima
}
