% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgcpMethods.R
\name{identify.lgcpPredict}
\alias{identify.lgcpPredict}
\title{identify.lgcpPredict function}
\usage{
\method{identify}{lgcpPredict}(x, ...)
}
\arguments{
\item{x}{an object of class lgcpPredict}

\item{...}{additional arguments}
}
\value{
a 2 x n matrix containing the grid indices of the points of interest, where n is the number of points selected via the mouse.
}
\description{
Identifies the indices of grid cells on plots of \code{lgcpPredict} objects. Can be used to identify
a small number of cells for further information eg trace or autocorrelation plots (provided data has been dumped to disk). On calling
\code{identify(lg)} for example (see code below), the user can click multiply with the left mouse button on the graphics device; once
the user has selected all points of interest, the right button is pressed, which returns them.
}
\examples{
\dontrun{plot(lg)} # lg an lgcpPredict object
\dontrun{pt_indices <- identify(lg)}
}
\seealso{
\link{lgcpPredict}, \link{loc2poly}
}

