% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgcp.R
\docType{package}
\name{lgcp-package}
\alias{lgcp-package}
\alias{lgcp}
\title{lgcp}
\format{
An object of class \code{logical} of length 1.
}
\usage{
lgcp
}
\description{
An R package for spatiotemporal prediction and forecasting for log-Gaussian Cox processes.
}
\details{
\packageDESCRIPTION{cruts}
\packageIndices{cruts}


For examples and further details of the package, type vignette("lgcp"), or refer to the paper associated with this package.

The content of \code{lgcp} can be broken up as follows:\cr

\emph{Datasets} wpopdata.rda, wtowncoords.rda, wtowns.rda. Giving regional and town poopulations as well as town coordinates,are provided by Wikipedia
and The Office for National Statistics under respectively
the Creative Commons Attribution-ShareAlike 3.0 Unported License and the Open Government Licence.\cr

\emph{Data manipulation}\cr

\emph{Model fitting and parameter estimation}\cr

\emph{Unconditional and conditional simulation}\cr

\emph{Summary statistics, diagnostics and visualisation}\cr

}

\section{Dependencies}{
The \code{lgcp} package depends upon some other important contributions to CRAN in order to operate; their uses here are indicated:\cr\cr
    spatstat, sp, RandomFields, iterators, ncdf, methods, tcltk, rgl, rpanel, fields, rgdal, maptools, rgeos, raster
}

\section{Citation}{
To see how to cite \code{lgcp}, type \code{citation("lgcp")} at the console.
}

\references{
\enumerate{
    \item Brix A, Diggle PJ (2001). Spatiotemporal Prediction for log-Gaussian Cox processes. Journal of the Royal Statistical Society, Series B, 63(4), 823-841.
    \item Diggle P, Rowlingson B, Su T (2005). Point Process Methodology for On-line Spatio-temporal Disease Surveillance. Environmetrics, 16(5), 423-434.
    \item Wood ATA, Chan G (1994). Simulation of Stationary Gaussian Processes in [0,1]d. Journal of Computational and Graphical Statistics, 3(4), 409-432.
    \item Moller J, Syversveen AR, Waagepetersen RP (1998). Log Gaussian Cox Processes. Scandinavian Journal of Statistics, 25(3), 451-482.
}
}
\author{
Benjamin Taylor, Health and Medicine, Lancaster University,
 Tilman Davies, Institute of Fundamental Sciences - Statistics, Massey University, New Zealand.,
 Barry Rowlingson, Health and Medicine, Lancaster University
 Peter Diggle, Health and Medicine, Lancaster University
}
\keyword{package}
