\name{evaluate} 
\alias{evaluate} 
\title{likeLTD::evaluate} 
\usage{evaluate(P.pars, D.pars, tolerance=1e-5, n.steps=NULL, progBar=TRUE, interim=FALSE)}
\arguments{
  \item{P.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.}
\item{D.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.}
\item{tolerance}{Tolerance for the final chunk of optimisation. If the relative difference 
between the current result, and the last checked result is less than this value, then it is 
classed as converged.}
\item{n.steps}{Number of steps to run. Defaults to NULL. if n.steps is NULL , the number
 of steps to run is determined by the mean of the standard deviation of the initial phase of 
the intial chunk of optimisation for prosecution and defence. }
\item{progBar}{Logical, stating whether to display a graphical progress basr or not. This should
be set to FALSE is the user does not have graphical capabilities e.g. if running from command
line on a server.}
\item{interim}{Logical, stating whether or not to generate interim reports. If set to TRUE a
basic set of results after each step is output to "Interim.csv" in the current working
directory. Each step will write over the results from the previous step.}

}
\value{
A list containing three elements:
\item{Pros}{Prosecution results, structured as results from DEoptim::DEoptim.}
\item{Def}{Defence results, structured as results from DEoptim::DEoptim.}
\item{WoE}{WoE for each chunk. The final value if the final WoE.}
} 
\description{
Optimize both prosecution and defence likelihoods, returning the weight of evidence.
}
\details{
  Optimize over parameter space, using a geometric progression of crossover rate and tolerance.
Both prosecution and defence cases are optimized simultaneously.
}
\seealso{DEoptim,DEoptimLoop}
