\name{reset}
\alias{reset}
\title{RESET Test}

\description{Ramsey's RESET test for functional relation.}

\usage{
reset(formula, power = 2:3, type = c("fitted", "regressor",
  "princomp"), data = list())
}

\arguments{
 \item{formula}{a symbolic describtion for the model to be tested.}
 \item{power}{integers. A vector of positive integers indicating
    the powers of the variables that should be included. By default
    it is tested for a quadratic or cubic influence of the fitted response.}
 \item{type}{a string indicating whether powers of the fitted response, the
    regressor variables (factors are left out) or the first principal
    component of the regressor matrix should be included in the
    extended model.}
 \item{data}{an optional data frame containing the variables in the model.
    By default the variables are taken from the environment which \code{reset}
    is called from.}
}

\details{
RESET test is popular means of diagnostic for correctness of functional
form. The basic assumption is that under the alternative, the model can be
written by the regression
\eqn{ y = X\beta + Z\gamma + u}{y=X * beta + Z * gamma}.
\code{Z} is generated by taking powers either of the fitted response, the
regressor variables or the first principal component of \code{X}. A standard
F-Test is then applied to determin whether these additional variables have
significant influence. The test statistic under \eqn{H_0} follows an F
distribution with \code{parameter} degrees of freedom.

Examples can not only be found on this page, but also on the help pages of the
data sets \code{\link{bondyield}}, \code{\link{currencysubstitution}},
\code{\link{growthofmoney}}, \code{\link{moneydemand}}, \code{\link{unemployment}},
\code{\link{wages}}.
}

\value{An object of class \code{"htest"} containing:
\itemize
\item{statistic}{the test statistic.}
\item{p.value}{the corresponding p-value.}
\item{parameter}{degrees of freedom.}
\item{method}{a character string with the method used.}
\item{data.name}{a character string with the data name.}
}
\references{

J.B. Ramsey (1969),
Tests for Specification Error in Classical Linear Least Squares Regression
Analysis.
\emph{Journal of the Royal Statistical Society, Series B} \bold{31},
350--371

W. Kraemer & H. Sonnberger (1986),
\emph{The Linear Regression Model under Test}. Heidelberg: Physica


}



\seealso{\code{\link{lm}}}

\examples{
x <- c(1:30)
y1 <- 1 + x + x^2 + rnorm(30)
y2 <- 1 + x + rnorm(30)
reset(y1 ~ x , power=2, type="regressor")
reset(y2 ~ x , power=2, type="regressor")
}

\keyword{htest}
