% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmmpower.R
\docType{methods}
\name{lmmpower}
\alias{lmmpower}
\alias{lmmpower.default}
\alias{lmmpower-methods}
\alias{lmmpower,ANY-method}
\alias{lmmpower,merMod-method}
\alias{lmmpower.lme}
\alias{lmmpower.gee}
\alias{lmmpower.numeric}
\alias{lmmpower.double}
\title{Sample size calculations for linear mixed models of rate of change based on
lmer, lme, or gee "placebo" pilot estimates.}
\usage{
\method{lmmpower}{default}(
  object = NULL,
  n = NULL,
  parameter = 2,
  pct.change = NULL,
  delta = NULL,
  t = NULL,
  sig.level = 0.05,
  power = NULL,
  alternative = c("two.sided", "one.sided"),
  beta = NULL,
  beta.CI = NULL,
  delta.CI = NULL,
  sig2.i = NULL,
  sig2.s = NULL,
  sig2.e = NULL,
  cov.s.i = NULL,
  cor.s.i = NULL,
  R = NULL,
  p = NULL,
  method = c("diggle", "liuliang", "edland", "hu"),
  tol = .Machine$double.eps^2,
  ...
)
}
\arguments{
\item{object}{an object returned by lme4}

\item{n}{sample size per group
of a mixed-effects model object to placebo data assumed to have either a
random intercept, or a random intercept and random effect for time (slope);
and fixed effect representing the rate of change in a placebo group.}

\item{parameter}{the name or position
of the rate of change parameter of interest, e.g. (\code{"time"},
\code{"t"}, or \code{2} if it is the second specified fixed effect).}

\item{pct.change}{the percent change
in the pilot estimate of the parameter of interest (\code{beta}, the
placebo/null effect)}

\item{delta}{the change in the pilot estimate
of the parameter of interest, computed from \code{pct.change} if left
missing.}

\item{t}{vector of time points}

\item{sig.level}{Type I error}

\item{power}{power}

\item{alternative}{\code{"two.sided"} or \code{"one.sided"}}

\item{beta}{pilot estimate of the placebo
effect (slope or rate of change in the outcome)}

\item{beta.CI}{95\% confidence limits of
the pilot estimate of beta}

\item{delta.CI}{95\% confidence limits of
the effect size}

\item{sig2.i}{pilot estimate of variance
of random intercept}

\item{sig2.s}{pilot estimate of variance
of random slope}

\item{sig2.e}{pilot estimate of residual
variance}

\item{cov.s.i}{pilot estimate of
covariance of random slope and intercept}

\item{cor.s.i}{pilot estimate of
correlation of random slope and intercept}

\item{R}{pilot estimate of a marginal
model working correlation matrix}

\item{p}{proportion vector for both groups; if i indexes visits, p[i] = the 
proportion whose last visit was at visit i (p sums to 1)}

\item{method}{the formula to use. Defaults
to \code{"diggle"} for Diggle et al (2002). Alternatively \code{"liuliang"}
can be selected for Liu & Liang (1997), \code{"edland"} for Ard & Edland (2011), 
or \code{"hu"} for Hu, Mackey & Thomas (2021).}

\item{tol}{numerical tolerance used in root finding.}

\item{...}{other arguments}
}
\value{
An object of class \code{power.htest} giving the calculated sample
size, N, per group and other parameters.
}
\description{
These functions compute sample size for linear mixed models based on the
formula due to Diggle (2002) or Liu and Liang (1997).  These formulae are
expressed in terms of marginal model or Generalized Estimating Equations
(GEE) parameters.  These functions translate pilot mixed effect model
parameters (e.g. random intercept and/or slope, fixed effects, etc.)  into
marginal model parameters so that either formula can be applied to
equivalent affect. Pilot estimates are assumed to be from an appropriate
"placebo" group and the parameter of interest is assumed to be the rate of
change over time of the outcome.
}
\details{
Any parameters not explicitly stated are extracted from the fitted
\code{object}.
}
\examples{

\dontrun{
browseVignettes(package = "longpower")
}

lmmpower(delta=1.5, t = seq(0,1.5,0.25),
	sig2.i = 55, sig2.s = 24, sig2.e = 10, cov.s.i=0.8*sqrt(55)*sqrt(24), power = 0.80)
lmmpower(n=208, t = seq(0,1.5,0.25),
	sig2.i = 55, sig2.s = 24, sig2.e = 10, cov.s.i=0.8*sqrt(55)*sqrt(24), power = 0.80)
lmmpower(beta = 5, pct.change = 0.30, t = seq(0,1.5,0.25),
	sig2.i = 55, sig2.s = 24, sig2.e = 10, cov.s.i=0.8*sqrt(55)*sqrt(24), power = 0.80)

\dontrun{
library(lme4)
fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy)
lmmpower(fm1, pct.change = 0.30, t = seq(0,9,1), power = 0.80)

library(nlme)
fm2 <- lme(Reaction ~ Days, random=~Days|Subject, sleepstudy)
lmmpower(fm2, pct.change = 0.30, t = seq(0,9,1), power = 0.80)

# random intercept only
fm3 <- lme(Reaction ~ Days, random=~1|Subject, sleepstudy)
lmmpower(fm3, pct.change = 0.30, t = seq(0,9,1), power = 0.80)

library(gee)
fm4 <- gee(Reaction ~ Days, id = Subject,
            data = sleepstudy,
            corstr = "exchangeable")
lmmpower(fm4, pct.change = 0.30, t = seq(0,9,1), power = 0.80)
}

}
\references{
Diggle P.J., Heagerty P.J., Liang K., Zeger S.L. (2002)
\emph{Analysis of longitudinal data}. Second Edition. Oxford Statistical
Science Series.

Liu, G., and Liang, K. Y. (1997) Sample size calculations for studies with
correlated observations. \emph{Biometrics}, 53(3), 937-47.

Ard, C. and Edland, S.D. (2011) Power calculations for clinical trials in Alzheimer's disease. 
\emph{Journal of Alzheimer's Disease.} 21:369-377. 

Hu, N., Mackey, H., & Thomas, R. (2021). Power and sample size
for random coefficient regression models in randomized experiments with
monotone missing data. \emph{Biometrical Journal}, 63(4), 806-824.
}
\seealso{
\code{\link{liu.liang.linear.power}},
\code{\link{diggle.linear.power}}, \code{\link{edland.linear.power}},
\code{\link{hu.mackey.thomas.linear.power}}
}
\author{
Michael C. Donohue
}
\keyword{effects}
\keyword{marginal}
\keyword{methods}
\keyword{mixed}
\keyword{model}
\keyword{power}
\keyword{random}
\keyword{sample}
\keyword{size}
