% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-glossary.R
\name{loo-glossary}
\alias{loo-glossary}
\title{LOO package glossary}
\description{
Note: VGG2017a refers to Vehtari, Gelman, and Gabry (2017a). See
  \strong{References}, below.
}
\section{ELPD and \code{elpd_loo}}{


The ELPD is the theoretical expected log pointwise predictive density for a new
dataset (Eq 1 in VGG2017a), which can be estimated, e.g., using
cross-validation. \code{elpd_loo} is the Bayesian LOO estimate of the
expected log pointwise predictive density (Eq 4 in VGG2017a) and
is a sum of N individual pointwise log predictive densities. Probability
densities can be smaller or larger than 1, and thus log predictive densities
can be negative or positive. For simplicity the ELPD acronym is used also for
expected log pointwise predictive probabilities for discrete models.
Probabilities are always equal or less than 1, and thus log predictive
probabilities are 0 or negative.
}

\section{Standard error of \code{elpd_loo}}{


As \code{elpd_loo} is defined as the sum of N independent components (Eq 4 in
VGG2017a), we can compute the standard error by using the standard deviation
of the N components and multiplying by \code{sqrt(N)} (Eq 23 in VGG2017a).
This standard error is a coarse description of our uncertainty about the
predictive performance for unknown future data. When N is small or there is
severe model misspecification, the current SE estimate is overoptimistic and
the actual SE can even be twice as large. Even for moderate N, when the SE
estimate is an accurate estimate for the scale, it ignores the skewness. When
making model comparisons, the SE of the component-wise (pairwise) differences
should be used instead (see the \code{se_diff} section below and Eq 24 in
VGG2017a).
}

\section{Monte Carlo SE of elpd_loo}{


The Monte Carlo standard error is the estimate for the computational accuracy
of MCMC and importance sampling used to compute \code{elpd_loo}. Usually this
is negligible compared to the standard describing the uncertainty due to
finite number of observations (Eq 23 in VGG2017a).
}

\section{\code{p_loo} (effective number of parameters)}{


\code{p_loo} is the difference between \code{elpd_loo} and the non-cross-validated
log posterior predictive density. It describes how much more difficult it
is to predict future data than the observed data. Asymptotically under
certain regularity conditions, \code{p_loo} can be interpreted as the
\emph{effective number of parameters}. In well behaving cases \code{p_loo < N} and
\code{p_loo < p}, where \code{p} is the total number of parameters in the
model. \code{p_loo > N}  or \code{p_loo > p} indicates that the model has very
weak predictive capability and may indicate a severe model misspecification.
See below for more on interpreting \code{p_loo} when there are warnings
about high Pareto k diagnostic values.
}

\section{Pareto k estimates}{


The Pareto \code{k} estimate is a diagnostic for Pareto smoothed importance
sampling (PSIS), which is used to compute components of \code{elpd_loo}. In
importance-sampling LOO (the full posterior distribution is used as the
proposal distribution). The Pareto k diagnostic estimates how far an
individual leave-one-out distribution is from the full distribution. If
leaving out an observation changes the posterior too much then importance
sampling is not able to give reliable estimate. If \code{k<0.5}, then the
corresponding component of \code{elpd_loo} is estimated with high accuracy.
If \code{0.5<k<0.7} the accuracy is lower, but still ok. If \code{k>0.7},
then importance sampling is not able to provide useful estimate for that
component/observation. Pareto k is also useful as a measure of influence of
an observation. Highly influential observations have high k values. Very high
k values often indicate model misspecification, outliers or mistakes in data
processing. See Section 6 of Gabry et al. (2019) for an example.

\subsection{Interpreting \code{p_loo} when Pareto \code{k} is large}{
If \code{k > 0.7} then we can also look at the \code{p_loo} estimate for
some additional information about the problem:

\itemize{
\item If \code{p_loo << p} (the total number of parameters in the model),
then the model is likely to be misspecified. Posterior predictive checks
(PPCs) are then likely to also detect the problem. Try using an overdispersed
model, or add more structural information (nonlinearity, mixture model,
etc.).

\item If \code{p_loo < p} and the number of parameters \code{p} is relatively
large compared to the number of observations (e.g., \code{p>N/5}), it is
likely that the model is so flexible or the population prior so weak that it’s
difficult to predict the left out observation (even for the true model).
This happens, for example, in the simulated 8 schools (in VGG2017a), random
effect models with a few observations per random effect, and Gaussian
processes and spatial models with short correlation lengths.

\item If \code{p_loo > p}, then the model is likely to be badly misspecified.
If the number of parameters \code{p<<N}, then PPCs are also likely to detect the
problem. See the case study at
\url{https://avehtari.github.io/modelselection/roaches.html} for an example.
If \code{p} is relatively large compared to the number of
observations, say \code{p>N/5} (more accurately we should count number of
observations influencing each parameter as in hierarchical models some groups
may have few observations and other groups many), it is possible that PPCs won't
detect the problem.
}
}
}

\section{elpd_diff}{

\code{elpd_diff} is the difference in \code{elpd_loo} for two models. If more
than two models are compared, the difference is computed relative to the
model with highest \code{elpd_loo}.
}

\section{se_diff}{


The standard error of component-wise differences of elpd_loo (Eq 24 in
VGG2017a) between two models. This SE is \emph{smaller} than the SE for
individual models due to correlation (i.e., if some observations are easier
and some more difficult to predict for all models).
}

\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017a). Practical
  Bayesian model evaluation using leave-one-out cross-validation and WAIC.
  \emph{Statistics and Computing}. 27(5), 1413--1432.
  doi:10.1007/s11222-016-9696-4.
  (\href{http://link.springer.com/article/10.1007\%2Fs11222-016-9696-4}{
  journal}, \href{http://arxiv.org/abs/1507.04544}{preprint arXiv:1507.04544}).

Vehtari, A., Gelman, A., and Gabry, J. (2017b). Pareto smoothed
importance sampling. arXiv preprint: \url{http://arxiv.org/abs/1507.02646/}

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
  Gelman, A. (2019), Visualization in Bayesian workflow. \emph{J. R. Stat.
  Soc. A}, 182: 389-402. doi:10.1111/rssa.12378,
  (\href{https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378}{journal},
  \href{https://arxiv.org/abs/1709.01449}{arXiv preprint})
}
