% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lsgl_navigate.R
\name{print.lsgl}
\alias{print.lsgl}
\title{Print function for lsgl}
\usage{
\method{print}{lsgl}(x, ...)
}
\arguments{
\item{x}{lsgl object}

\item{...}{ignored}
}
\description{
This function will print some general information about the lsgl object
}
\examples{
set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 100 #number of samples
p <- 25 #number of features
K <- 15  #number of groups

B<-matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)

X<-matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y<-X\%*\%B+matrix(rnorm(N*K,0,1),N,K)

lambda<-lsgl.lambda(X,Y, alpha=1, d = 25, lambda.min= 5, intercept=FALSE)
fit <-lsgl(X,Y, alpha=1, lambda = lambda, intercept=FALSE)

# Print some information about the estimated models
fit

## Cross validation
fit.cv <- lsgl.cv(X, Y, alpha = 1, lambda = lambda, intercept = FALSE)

# Print some information
fit.cv
}
\author{
Martin Vincent
}

