% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paint.R
\name{painting}
\alias{painting}
\alias{image_fill}
\alias{image_annotate}
\title{Image Painting}
\usage{
image_fill(image, color, point = "1x1", fuzz = 0)

image_annotate(image, text, gravity = "northwest", location = "+0+0",
  degrees = 0, size = 10, font = NULL, color = NULL,
  strokecolor = NULL, boxcolor = NULL)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{color}{a valid \href{https://www.imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}}

\item{point}{string indicating the flood-fill starting point}

\item{fuzz}{Colors within this distance are considered equal.
Use this option to match colors that are close to the target color in RGB space.
I think max distance (from #000000 to #FFFFFF) is 256^2.}

\item{text}{annotation text}

\item{gravity}{string with
\href{https://www.imagemagick.org/Magick++/Enumerations.html#GravityType}{gravity type}}

\item{location}{geometry string with location relative to \code{gravity}}

\item{degrees}{rotates text around center point}

\item{size}{font-size in pixels}

\item{font}{rendering font. To use a TrueType font, precede the TrueType filename with an @.}

\item{strokecolor}{adds a stroke (border around the text)}

\item{boxcolor}{background color that annotation text is rendered on.}
}
\description{
The \code{\link[=image_fill]{image_fill()}} function performs flood-fill by painting starting point and all
neighboring pixels of approximately the same color. Annotate simply prints some
text on the image.
}
\details{
Note that more sophisticated drawing mechanisms are available via the graphics
device using \link{image_draw}.
}
\examples{
logo <- image_read("logo:")
logo <- image_transparent(logo, 'white')
image_fill(image_flatten(logo), "red")
image_fill(image_flatten(logo), "red", fuzz = 25600)
# Add some text to an image
image_annotate(logo, "This is a test")
image_annotate(logo, "CONFIDENTIAL", size = 50, color = "red", boxcolor = "pink",
 degrees = 30, location = "+100+100")

# Setting fonts requires fontconfig support (and that you have the font)
myfont <- ifelse(identical("windows", .Platform$OS.type), "courier-new", "courier")
try(image_annotate(logo, "The quick brown fox", font = myfont, size = 50))
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{editing}},
  \code{\link{effects}}, \code{\link{ocr}},
  \code{\link{transform}}
}
