% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_functions.R
\name{franzmann_kaiser}
\alias{fk_smoothing}
\alias{franzmann_kaiser}
\alias{read_fk_issue_structure}
\title{Left-Right Scores based on Franzmann & Kaiser Method}
\usage{
franzmann_kaiser(data, basevalues = TRUE, smoothing = TRUE,
  vars = grep("per\\\\d{3}$", names(data), value = TRUE),
  issue_structure = read_fk_issue_structure(mean_presplit = mean_presplit),
  party_system_split = split_belgium, mean_presplit = TRUE, ...)

read_fk_issue_structure(path = system.file("extdata",
  "fk_issue_structure.sav", package = "manifestoR"), mean_presplit = TRUE)

fk_smoothing(data, score_name, use_period_length = TRUE, ...)
}
\arguments{
\item{data}{A data.frame with cases to be scaled, variables named "per..."}

\item{basevalues}{flag for transforming data to be relative to the minimum}

\item{smoothing}{flag for using smoothing}

\item{vars}{Variables/Categories to use for computation of score. Defaults to all
available handbook version 4 categories.}

\item{issue_structure}{issue structure to use for Franzmann & Kaiser method, default to original replication values}

\item{party_system_split}{function to recode the country variable to re-partition
party systems. Defaults to splitting Belgium into two halfs as done in Franzmann 2009}

\item{mean_presplit}{if TRUE, for Belgium as a whole (before the split into two
party systems) the mean of the issue weights is used (which is equal to taking
the mean of the output values, since all subsequent transformations are linear). This step
is required to replicate the Franzmann 2009 dataset.}

\item{...}{passed on to fk_smoothing and \code{party_system_split}}

\item{path}{path from were to read issue structures (as SPSS data file). Defaults
to the file bundled in the manifestoR package from the replication material of
Franzmann 2009.}

\item{score_name}{name of variable with LR Score values to be smoothed}

\item{use_period_length}{whether to use electoral period length in weighting}
}
\description{
Computes left-right scores based on the Franzmann & Kaiser Method (see
reference below). The issue structures are not calculated from scratch but
taken as given from Franzmann 2009. Note that they are not available for the
entire Manifesto Project Dataset, but only for a subset of countries and elections.
}
\references{
Franzmann, Simon/Kaiser, Andre (2006): Locating Political Parties in Policy Space. A Reanalysis of Party Manifesto Data, Party Politics, 12:2, 163-188

Franzmann, Simon (2009): The Change of Ideology: How the Left-Right Cleavage transforms into Issue Competition. An Analysis of Party Systems using Party Manifesto Data. PhD Thesis. Cologne.
}

