% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issue_attention.R
\name{issue_attention_diversity}
\alias{issue_attention_diversity}
\title{Issue Attention Diversity}
\usage{
issue_attention_diversity(data, method = "shannon", prefix = "per",
  include_variables = paste0(prefix, setdiff(v4_categories(), "uncod")),
  aggregate_categories = list(c(101, 102), c(104, 105), c(107, 109), c(108,
  110), c(203, 204), c(301, 302), c(406, 407), c(409, 414), c(504, 505), c(506,
  507), c(601, 602), c(603, 604), c(607, 608), c(701, 702)))
}
\arguments{
\item{data}{a data.frame in format of Manifesto Project Main Dataset}

\item{method}{entropy measure used for the effective number of manifesto issues. Possible options are "shannon" for Shannon's H and "herfindahl" for the Herfindahl-Index.}

\item{prefix}{Prefix of variable names to use (usually "per")}

\item{include_variables}{names of variables to include}

\item{aggregate_categories}{list of category groups to aggregate into one issue. Default to selection used in Greene 2015}
}
\description{
Effective number of Manifesto Issues suggested by Zac Greene. When using the measure please cite Greene 2015 (see reference below)
}
\references{
Greene, Z. (2015). Competing on the Issues How Experience in Government and Economic Conditions Influence the Scope of Parties' Policy Messages. Party Politics.
}
