% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapshot.R
\name{mapshot}
\alias{mapshot}
\title{Save mapview or leaflet map as HTML and/or image}
\usage{
mapshot(x, url = NULL, file = NULL, remove_url = TRUE, ...)
}
\arguments{
\item{x}{\code{mapview} or \code{leaflet} object.}

\item{url}{Output \code{.html} file. If not supplied and 'file' is specified,
a temporary index file will be created.}

\item{file}{Output \code{.png}, \code{.pdf}, or \code{.jpeg} file.}

\item{remove_url}{\code{logical}. If \code{TRUE} (default), the \code{.html}
file is removed once processing is completed. Only applies if 'url' is not
specified.}

\item{...}{Further arguments passed on to \code{\link{webshot}}.}
}
\description{
Save a mapview or leaflet map as \code{.html} index file or \code{.png},
\code{.pdf}, or \code{.jpeg} image.
}
\examples{
\dontrun{
m <- mapview(breweries91)

## create standalone .html
mapshot(m, url = paste0(getwd(), "/map.html"))

## create standalone .png; temporary .html is removed automatically unless
## 'remove_url = FALSE' is specified
mapshot(m, file = paste0(getwd(), "/map.png"))

## create .html and .png
mapshot(m, url = paste0(getwd(), "/map.html"),
        file = paste0(getwd(), "/map.png"))
}

}
\seealso{
\code{\link{webshot}}, \code{\link{saveWidget}}.
}

