% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mat.polyn.R
\name{inverse.form}
\alias{inverse.form}
\title{inverse.form}
\usage{
inverse.form(ar.poly, ma.poly, L)
}
\arguments{
\item{ar.poly}{=autoregressive matrix part of model (array(k,k,ar-order)).}

\item{ma.poly}{=moving average matrix part of model (array(k,k,ma-order)).}

\item{L}{=order of return polynomial (length=L+1 including leading
unity matrix).}
}
\value{
inverse form for arma model up to order L (array(k,k,L+1)).
}
\description{
Calculation of inverse form for arma model
}
\examples{
set.seed(4711)
p1  <- check.one(matrix(rnorm(16),nrow=4))
p2  <- check.one(array(rnorm(32),dim=c(4,4,2)))
inverse <- inverse.form(ar.poly=p1,ma.poly=p2,L=6)
short.form(inverse)
}

