% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defining.programs.R
\name{define.model}
\alias{define.model}
\title{define.model}
\usage{
define.model(kvar = 1, ar = 0, ma = 0, rem.var = 0, reg.var = 0,
  no.dep = NULL, print = 0, ar.fill = NULL, ar.rem = NULL,
  ma.fill = NULL, ma.rem = NULL, indep = NULL)
}
\arguments{
\item{kvar}{dimension of time series}

\item{ar}{autoregresssion definition. For example ar=c(1, 2, 12) will
generate autoregression at lags 1, 2 and 12.}

\item{ma}{moving average definition. Works like ar. If ma=c(1, 2) moving
average terms at lags 1 and 2 are defined.}

\item{rem.var}{no. of variable(s) not to be considered in marima.}

\item{reg.var}{no. of variable(s) that can only act as regression
variable(s) such as (typically) a socalled leading indicator.}

\item{no.dep}{sequence of pairs of variables. For example
no.dep=c(1, 2, 2, 3) means that variable 2 is not allowed in model
for variable 1, and variable 3 is not allowed in model for variable 2.}

\item{print}{(!0/0) If !0 is used, the generated patterns of the
arma model and other informations are printed on the console.
If 0 is used, no printout of the arma patterns are given.}

\item{ar.fill}{sequence of triplets: c(dependent variable, independent
variable, lag). ar.fill=c(2, 3, 12): Insert ar-indicator for model for
dependent variable 2 and independent variable 3 at lag 12.}

\item{ar.rem}{sequence of triplets c(dependent variable, independent
variable, lag). ar.rem=c(2, 3, 12): remove (if present) ar-indicator for model
for dependent variable 2 and independent variable 3 at lag 12.}

\item{ma.fill}{sequence of triplets: c(dependent variable, independent
variable, lag). ma.fill=c(2, 3, 12): Insert ma-indicator for model for
dependent variable 2 and independent variable 3 at lag 12.}

\item{ma.rem}{sequence of triplets c(dependent variable, independent
variable, lag). ma.rem=c(2, 3, 12): remove (if present) ma-indicator for model
for dependent variable 2 and independent variable 3 at lag 12.

The various parameters may (in some cases) accomplish the same model
requirements. The routine define.model apply these input parameters
successively in the following order: 1) rem.var, 2) reg.var, 3) indep,
4) no.dep, 5) ar.fill, 6) ar.rem, 7) ma.fil, 8) ma.rem

The parameters ar.fill, ar.rem, ma.fill and ma.rem are applied last, and
in that order. They overwrite what previously has been defined.}

\item{indep}{no. of variable(s) that are independent of the other
variables. indepc(2, 4) makes variables 2 and 4 independent of all
other variables. Variables 2 and 4 may influence other variables.}
}
\value{
ar.pattern  a matrix polynomium (an array) with 1's and 0's
defining
the autoregressive matrix polynomium to be fitted by marima (an array
with dim=c(kvar, kvar, 1+ar_order) (with leading unity matrix)).

ma.pattern  a matrix polynomium (an array) with 1's and 0's
defining
the moving average matrix polynomium to be fitted by marima (an array
with dim=c(kvar, kvar, 1+ma_order) (including the leading unity
matrix)).
}
\description{
Function to define multivariate arma model
(indicator form) for marima.
}
\examples{
#
# Example 1: 3-variate arma model with ar-lags at 1 and 2, and an
# ma-term at lag 1. And var=3 is a regression variable (X-variable).
#
 Model1 <- define.model(kvar=3, ar=c(1, 2), ma=c(1), reg.var=3)
 short.form(Model1$ar.pattern)
 short.form(Model1$ma.pattern, leading=FALSE)
#
# The object Model1 contains the ar- and ma-pattern arrays as defined.
#
# Model1$ar.pattern and Model1$ma.pattern are used as input to
# marima in order to define the model to be estimated.
#
# Example 2: arma model with ar-lags at 1, 2 and 6, and var=3
#  regression variable (X-variable).
#
 Model2 <- define.model(kvar=3, ar=c(1, 2, 6), ma=c(1), reg.var=3)
# Print the ar- and ma-polynomial patterns using
 short.form(Model2$ar.pattern, leading=FALSE)
 short.form(Model2$ma.pattern, leading=TRUE)
#
# Example 3: arma model with ar-lags at 1, 2 and 6, and reg.var=3
# (X-variable). ma-order=1. Finally (ar.fill=c(2, 3, 4) puts  a '1'
# for (dep-var=2, indep-var=3, ar-lag=4).
#
# If further modifications of the ar- or ma-patterns are needed, it
# can be accomplished before calling marima (Model3$ar.pattern and
# Model3$ma.pattern are arrays).
#
 Model3 <- define.model(kvar=3, ar=c(1, 2, 6), ma=c(1), reg.var=3,
    ar.fill=c(2, 3, 4))
 short.form(Model3$ar.pattern)
 short.form(Model3$ma.pattern)
#
 Model4 <- define.model(kvar=3, ar=c(1, 2, 6), ma=c(1), reg.var=3, 
 ar.fill=c(2, 3, 4), indep=c(1))
 short.form(Model4$ar.pattern)
 short.form(Model4$ma.pattern, leading=FALSE)

}

