% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.design.data.R
\name{make.design.data}
\alias{make.design.data}
\title{Create design dataframes for crm}
\usage{
make.design.data(data, parameters = list())
}
\arguments{
\item{data}{Processed data list; resulting value from process.data}

\item{parameters}{Optional list containing a list for each type of parameter
(list of lists); each parameter list is named with the parameter name (eg
Phi); each parameter list can contain vectors named age.bins,time.bins and
cohort.bins, time.varying, and static \tabular{ll}{ \code{age.bins} \tab bins
for binning ages\cr \code{time.bins} \tab bins for binning times\cr
\code{cohort.bins} \tab bins for binning cohorts\cr \code{time.varying} \tab
vector of field names that are time varying for this parameter\cr
\code{static} \tab vector of field names that are to be included that are
not time varying for this parameter\cr }}
}
\value{
The function value is a list of data frames. The list contains a
data frame for each type of parameter in the model (e.g., Phi and p for
CJS).  The names of the list elements are the parameter names (e.g., Phi).
The structure of the dataframe depends on the calling arguments and the
model & data structure. In addition the value of parameters argument is saved as design.parameters.
}
\description{
For each type of parameter in the analysis model (e.g, p, Phi), this
function creates design data for model fitting from the original data. 
These design data expand the original data record for a single(freq=1)/multiple(freq>1) individuals
to many records where each record is for a single occasion. The design data can
be specific to the parameter and a list of design data frames are returned with a dataframe
for each parameter.
}
\details{
For each record in the design data, default data fields are created based on the model. For example,
for CJS, the default fields include cohort, age, time which are factor variables and Cohort, Age, and Time
which are numeric versions of the same fields.  The values of these can be altered by values of 
begin.time, time.intervals and initial.ages set in the call to \code{\link{process.data}}. In addition if groups are identifed the
grouping factor variables are added to the design data. Any other fields in the data are repeated on each record
for the animal(s) (eg weight), unless they are defined as time.varying in which case the fields should be named
with the convention xn where x is the base name for the variable and n is the time value (eg, td1999, td2000,...).
For time varying fields the variable name in the design data is the base name and the value for the record is
the one for that occasion(time). The variables can be refined for each parameter by including argument static with the
character vector of static fields to include.

After creating design data, you can create a field in the dataframe for a parameter named fix and it can be assigned values
at the real parameter for that occasion/id will be fixed at the value. For parameters that are not supposed to be fixed, the field
fix should be assigned NA.  For example, ddl$Phi$fix=ifelse(ddl$Phi$time==2,1,NA) will assign all real Phi values to 1 for the interval
beginning at time 2. If there is no field fix, then no parameters are fixed.  For mlogit parameters, a fix field is added automatically and
the value 1 is specified for the stratum that is supposed to be computed by subtraction and the remainder are set to NA.  If some Psi are not possible
then those values can be changed to 0.

The following variable names are reserved and should not be used in the data:
occ,age,time,cohort,Age,Time,Cohort,Y,Z,initial.age,begin.time,time.interval,fix
}
\examples{
\donttest{
# This example is excluded from testing to reduce package check time
data(dipper)
dipper.proc=process.data(dipper)
ddl=make.design.data(dipper.proc)
}
}
\author{
Jeff Laake
}
\seealso{
\code{\link{process.data}},\code{\link{merge_design.covariates}}
}
\keyword{utility}

