\name{create.dm}
\alias{create.dm}
\alias{create.dml}
\title{Creates a design matrix for a parameter}
\usage{
create.dm(x, formula, time.bins=NULL, cohort.bins=NULL, age.bins=NULL,
                  chunk_size=1e7, remove.intercept=NULL,remove.unused.columns=TRUE)

       create.dml(ddl,model.parameters,design.parameters,restrict=FALSE,
             chunk_size=1e7,use.admb=FALSE,remove.unused.columns=TRUE)
}
\arguments{
  \item{x}{design dataframe created by
  \code{\link{create.dmdf}}}

  \item{formula}{formula for model in R format}

  \item{time.bins}{any bins of time to collapse values}

  \item{cohort.bins}{any bins of cohort to collapse values}

  \item{age.bins}{any bins of cohort to collapse values}

  \item{chunk_size}{specifies amount of memory to use in
  creating design matrices; amount used is 8*chunk_size/1e6
  MB (default 80MB)}

  \item{remove.intercept}{if TRUE, forces removal of
  intercept in design matrix}

  \item{ddl}{Design data list which contains a list element
  for each parameter type; if NULL it is created}

  \item{design.parameters}{Specification of any grouping
  variables for design data for each parameter}

  \item{model.parameters}{List of model parameter
  specifications}

  \item{restrict}{if TRUE, only use design data with Time
  >= Cohort}

  \item{use.admb}{if TRUE uses mixed.model.admb for random
  effects; otherwise mixed.model}

  \item{remove.unused.columns}{if TRUE, unused columns are
  removed; otherwise they are left}
}
\value{
create.dm returns a fixed effect design matrix constructed
with the design dataframe and the formula for a single
parametre.  It excludes any columns that are all 0.
create.dml returns a list with an element for for each
parameter with a sub-list for the fixed effect (fe) and
random effects. The re structure depends on switch
use.admb. When TRUE, it contains a single design matrix
(re.dm) and indices for random effects (re.indices). When
FALSE, it returns re.list which is a list with an element
for each random component containing re.dm and indices for
that random effect (eg (1|id) + (1|time) would produce
elements for id and time.
}
\description{
Creates a design matrix using the design dataframe, a
formula and any intervals defined for time, cohort and age.
}
\author{
Jeff Laake
}

