#-------------------------------------------------------------------------------
# FacebookInsightsDashboard.R (marketeR) - made with <3 by fmikaelian
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#' @title A simple dashboard for social media managers who use
#'   Facebook insights
#' @description \code{FacebookInsightsDashboard} allows faster and easier data
#'   exploration without having to care about coding.
#' @details The dashboard parameters are :
#' \itemize{
#' 
#' \item{\code{token : }} {You can get your token by launching the Graph API explorer from
#'   Facebook, available at \url{https://developers.facebook.com/tools/explorer/}.
#'   You just have to copy/paste it from the box shown above to the dashboard.
#'   For security reasons, your token will expire if you log-out your Facebook
#'   account or after 30 minutes of activity.}
#' \item{\code{object_ID : }} {Your \code{object_ID} could be a \code{page_ID}, a
#'   \code{post_ID}, or a \code{domain_ID}. Assuming you want to get insights for
#'   a page, you will find the \code{page_ID} within the Facebook URL of the page.
#'   The URL syntax should look like this : facebook.com/\code{page_ID}.}
#' \item{\code{dates : }} {Just select the date range for your insights query.}
#' \item{\code{metric :}} {The insights metric reference is available at
#'   \url{https://developers.facebook.com/docs/graph-api/reference/v2.4/insights}.
#'   As you can see, some metrics are page-related, some others are post-related
#'   or even domain-related. So be sure you selected an \code{object_ID} type
#'   that matches the metric you chose.}
#' \item{\code{period : }} {The period parameter is different from the \code{start/end-date}
#'   parameter. For instance, if you chose a \code{period=week}, results will
#'   still show daily values. To be more precise, if the \code{page_impressions}
#'   (\code{period=week}) for the date Friday May 8th is X, that means that from
#'   Friday May 1st to Friday May 8th, there was a total of X
#'   \code{page_impressions}. It is the same concept for other period parameters.}
#' }
#' 
#' @note If you need to export the graphics generated by the dashboard, or just
#'   want to store the raw data extracted from Facebook, you can use the
#'   download buttons.
#' @examples \dontrun{FacebookInsightsDashboard()}
#' @export
#-------------------------------------------------------------------------------

FacebookInsightsDashboard <- function() {

  #-----------------------------------------------------------------------------
  # Find then run the Shiny app
  #-----------------------------------------------------------------------------

  appDir <- system.file("FacebookInsightsDashboard", package = "marketeR")
  if (appDir == "") {
    stop("Could not find given directory. Try re-installing marketeR.", call. = FALSE)
  }

  shiny::runApp(appDir, display.mode = "normal")

}
